/**
 * Processor specific programs to handle all the peripherals. This file should be rewritten for a different processor from those
 *
 * who knows how things happens
 -------------------------------------------------------------------------------------------------------------------------------------------*/
#include <c_types.h>
#include <ip_addr.h>
#include <ets_sys.h>
#include <espconn.h>
#include <osapi.h>
#include <mem.h>
#include <gpio.h>
#include <os_type.h>
#include <stdlib.h>
//#include "ESPProcessorSpecific.h"
#include "globals.h"
#include "uart.h"
//#include "../mule/MySubroutines.c"


//--------------------------------------------------------------------------------------------------------------------------------------------
/**
 * Processor specific program to init globals
 */
void ICACHE_FLASH_ATTR HDinit(){                                    //* Init hardware according to HD version
u8 i;
#if versionHD == 1                              // EPS-01
	ALLINs[0] =	PERIPHS_IO_MUX_GPIO0_U;			//0
	ALLINs[1] =	-1;
	ALLINs[2] =	PERIPHS_IO_MUX_GPIO2_U;			//2
	ALLINs[3] =	-1;
	ALLINs[4] =	-1;								//4
	ALLINs[5] =	-1;								//5
	ALLINs[6] =	-1;
	ALLINs[7] =	-1;
	ALLINs[8] =	-1;
	ALLINs[9] =	-1;
	ALLINs[10]= -1;
	ALLINs[11]= -1;
	ALLINs[12]= -1;								//12
	ALLINs[13]= -1;								//13
	ALLINs[14]= -1;								//14
	ALLINs[15]= -1;								//15

	ALLOUTs[0] = PERIPHS_IO_MUX_GPIO0_U;		//0
	ALLOUTs[1] = -1;
	ALLOUTs[2] = PERIPHS_IO_MUX_GPIO2_U;		//2
	ALLOUTs[3] = -1;
	ALLOUTs[4] = -1;							//4
	ALLOUTs[5] = -1;							//5
	ALLOUTs[6] = -1;
	ALLOUTs[7] = -1;
	ALLOUTs[8] = -1;
	ALLOUTs[9] = -1;
	ALLOUTs[10]= -1;
	ALLOUTs[11]= -1;
	ALLOUTs[12]= -1;							//12
	ALLOUTs[13]= -1;							//13
	ALLOUTs[14]= -1;							//14
	ALLOUTs[15]= -1;							//15

	ALLANGs[0]= -1;	                			/// all analog input available pins
#endif

#if versionHD == 3                              // EPS-03
	ALLINs[0] =	PERIPHS_IO_MUX_GPIO0_U;			//0
	ALLINs[1] =	-1;
	ALLINs[2] =	PERIPHS_IO_MUX_GPIO2_U;			//2
	ALLINs[3] =	-1;
	ALLINs[4] =	-1;								//4
	ALLINs[5] =	-1;								//5
	ALLINs[6] =	-1;
	ALLINs[7] =	-1;
	ALLINs[8] =	-1;
	ALLINs[9] =	-1;
	ALLINs[10]=-1;
	ALLINs[11]=-1;
	ALLINs[12]= PERIPHS_IO_MUX_MTDI_U;			//12
	ALLINs[13]= PERIPHS_IO_MUX_MTCK_U;			//13
	ALLINs[14]= PERIPHS_IO_MUX_MTMS_U;			//14
	ALLINs[15]= PERIPHS_IO_MUX_MTDO_U;			//15

	ALLOUTs[0] = PERIPHS_IO_MUX_GPIO0_U;		//0
	ALLOUTs[1] = -1;
	ALLOUTs[2] = PERIPHS_IO_MUX_GPIO2_U;		//2
	ALLOUTs[3] = -1;
	ALLOUTs[4] = -1;							//4
	ALLOUTs[5] = -1;							//5
	ALLOUTs[6] = -1;
	ALLOUTs[7] = -1;
	ALLOUTs[8] = -1;
	ALLOUTs[9] = -1;
	ALLOUTs[10]= -1;
	ALLOUTs[11]= -1;
	ALLOUTs[12]= PERIPHS_IO_MUX_MTDI_U;			//12
	ALLOUTs[13]= PERIPHS_IO_MUX_MTCK_U;			//13
	ALLOUTs[14]= PERIPHS_IO_MUX_MTMS_U;			//14
	ALLOUTs[15]= PERIPHS_IO_MUX_MTDO_U;			//15

	ALLANGs[0]= -1;	                			/// all analog input available pins
#endif

#if versionHD == 7                          // EPS-07
	ALLINs[0] =	PERIPHS_IO_MUX_GPIO0_U;			//0
	ALLINs[1] =	-1;
	ALLINs[2] =	PERIPHS_IO_MUX_GPIO2_U;			//2
	ALLINs[3] =	-1;
	ALLINs[4] =	PERIPHS_IO_MUX_GPIO4_U;			//4
	ALLINs[5] =	PERIPHS_IO_MUX_GPIO5_U;			//5
	ALLINs[6] =	-1;
	ALLINs[7] =	-1;
	ALLINs[8] =	-1;
	ALLINs[9] =	-1;
	ALLINs[10]= -1;
	ALLINs[11]= -1;
	ALLINs[12]= PERIPHS_IO_MUX_MTDI_U;			//12
	ALLINs[13]= PERIPHS_IO_MUX_MTCK_U;			//13
	ALLINs[14]= PERIPHS_IO_MUX_MTMS_U;			//14
	ALLINs[15]= PERIPHS_IO_MUX_MTDO_U;			//15

	ALLOUTs[0] = PERIPHS_IO_MUX_GPIO0_U;		//0
	ALLOUTs[1] = -1;
	ALLOUTs[2] = PERIPHS_IO_MUX_GPIO2_U;			//2
	ALLOUTs[3] = -1;
	ALLOUTs[4] = PERIPHS_IO_MUX_GPIO4_U;			//4
	ALLOUTs[5] = PERIPHS_IO_MUX_GPIO5_U;			//5
	ALLOUTs[6] = -1;
	ALLOUTs[7] = -1;
	ALLOUTs[8] = -1;
	ALLOUTs[9] = -1;
	ALLOUTs[10]= -1;
	ALLOUTs[11]= -1;
	ALLOUTs[12]= PERIPHS_IO_MUX_MTDI_U;			//12
	ALLOUTs[13]= PERIPHS_IO_MUX_MTCK_U;			//13
	ALLOUTs[14]= PERIPHS_IO_MUX_MTMS_U;			//14
	ALLOUTs[15]= PERIPHS_IO_MUX_MTDO_U;			//15

	ALLANGs[0]= 1;	                		/// all analog input available pins
#endif


//network_init();                               // Network init
	//wifi_station_disconnect();
	//wifi_station_set_auto_connect(0);			// Disable auto connect on power on
	wifi_set_opmode(1);
	for (i=0;i<PIPE_COUNT;i++){
	  //pipesWiFi[i]->pipe_id=-1;
	  //pipesWiFi[i]->mode=0;
	  //pipesAttachedFile[i].pipe_id=-1;		// moved to initFS
	  //pipesAttachedFile[i].mode=0;
	  pipesUart0[i].pipe_id=-1;
	}

	for (i=0; i<INTERFACES_NUM; i++){
		myStreams[i].pipe_count=0;
		myStreams[i].rxPipe.r=0;
		myStreams[i].txPipe.r=0;
	}

	gpio_init();								// Initialize the GPIO subsystem.

//	U0 init console default to USART, interface 0, pipe 0
	initSerial(0,"1,0,96,8N1,0");			// intfN:, subType, baud rate, bits, parity, stop bits, HD flow contr.
	os_delay_us(100);
	TRACE_DEBUG("RS open,S=%d\r\n",myInterfaces[0].id);

	//initWiFi(1,"2,\"esp0\",\"\"");			// intfN:, subType, baud rate, bits, parity, stop bits, HD flow contr.
	//os_delay_us(100);
	//TRACE_DEBUG("RS open,S=%d\r\n",myInterfaces[0].id);

//	P0 init
	if(myInterfaces[0].openPipe>0) (*myInterfaces[0].openPipe)(0,0,"");
	//if(myInterfaces[0].openPipe>0) (*myInterfaces[1].openPipe)(0,1,"S,\"TCP\",2345");
	TRACE_DEBUG("Pipe0 open\r\n");
}


//--------------------------------------------------------------------------------------------------------------------------------------------
/**
 * Processor specific program to manage pins as Outputs
 * @param val represents hex value 1=In, 0=No
 */
BOOL ICACHE_FLASH_ATTR setOuts(u8 pin){                 //* Configure all Digital OutPins according to pins from instruction O(xx,yy,zz,..)
		u8 i;
		if(ALLOUTs[pin]==-1) return FALSE;
		PIN_FUNC_SELECT(ALLOUTs[pin],(pin<6)? 0:3);		// set FUNC_GPIO to pin
		//GPIO_OUTPUT_SET(pin,0);
		return TRUE;
}

/**
 * Processor specific program to manage pins as Inputs
 * @param val represents hex value 1=Out, 0=No
 */
BOOL ICACHE_FLASH_ATTR setIns(u8 pin){                  //* Configure all Digital InPins according to pins from instruction I(xx,yy,zz,..)
	u8 i;
	if(ALLINs[pin]==-1) return FALSE;
	PIN_FUNC_SELECT(ALLINs[pin],(pin<6)? 0:3);			// set FUNC_GPIO to pin
	GPIO_DIS_OUTPUT(pin);
    return TRUE;
}

BOOL ICACHE_FLASH_ATTR setAnalogs(u8 pin){  			//* Configure all Analog InPins
	return TRUE;
}
/**
 * Processor specific program to start ADC
 */
void ICACHE_FLASH_ATTR initAnalogs(){
}

/**
 * Processor specific program to init pins as Analog Inputs
 * @param val represents hex value 1=Analog, 0=Digital
 */
BOOL ICACHE_FLASH_ATTR setAnalog(){                              //* Configure all Analog InPins according to pins from instruction A(xx,yy,zz,..)
	analogPins[0]=0;
    return TRUE;
}

void ICACHE_FLASH_ATTR doIns(){                               //* Checks all InPins and set corresponding bit in myIns (a bridge between InPins<->myIns)
    u8 i;
    // doDigital Ins
    for (i=0; i<sizeof(RANGE)*8; i++){
    	if(inputPins[i]>=0){
			if(GPIO_INPUT_GET(inputPins[i])>0)	bitset(&myIns,i);
			else bitclr(&myIns,i);
    	}
    }
    if(analogPins[0]>=0) myAnalogs[0]=system_adc_read();                               // update ADC value
}

void ICACHE_FLASH_ATTR doOuts(u8 i){
    if(i!=0xff) goto Lab_1;
    for (i=0;i<sizeof(RANGE)*8;i++)
Lab_1:
    {
    	if(outputPins[i]>=0){
			if(bitchk(&myOuts,i)) {GPIO_OUTPUT_SET(outputPins[i],1);}
			else GPIO_OUTPUT_SET(outputPins[i],0);
    	}
    }
}

//--------------------------------------------------------------------------------------------------------------------------------------------
u16	ICACHE_FLASH_ATTR readMProgram(){									// fill m_program table with row addresses
#ifdef USE_RAM_PRG
	u16 i=0,j;
	bool NEW_LINE=FALSE;
	h = (fileMountAddress[INTERFACES_NUM - 2].ping>0) ? fileMountAddress[INTERFACES_NUM - 2].ping : fileMountAddress[INTERFACES_NUM - 2].pong;
	m_len = FATtable[myInterfaces[INTERFACES_NUM - 2].id].length;

	for (j = 0; j<M_ROWS; j++) m_program[j] = NULL;					// clear all program row pointers
	m_program[1] = h;												// i=1 initial
	for (j = 0; j<m_len; j++){
		if (*(h + j) == 26) return i;
		if (NEW_LINE){
			i++;
			m_program[i] = h + j;
			NEW_LINE = FALSE;
		}
		if (j>0 && *(h + j) == '\n' && *(h + j - 1) == '\r'){
			if(i==0) i=1;
			NEW_LINE = TRUE;			// "\r\n" is the end of a row
		}
	}
	//ETS_UART_INTR_ENABLE();
	return i;
#endif
#ifdef USE_ROM_PRG

#endif
}
/** --------------------------------------------------------------------------------------------------------------------------------------------
 * 	Take in account that flash is 4B aligned (word of 4 Bytes)
 */
u8* ICACHE_FLASH_ATTR loadRow(u16 num){		/// loads row[] with m_program(rowN)
	extern u8 myRow[];							/// holds a copy of current mule processing row
	u8 *row = myRow;
#ifdef USE_ROM_PRG
	if (num>maxRowN) return row;
	else{
		not ready yet!
			const char *s = m_program[num];
		curRow = myRow;
		while (*s){
			*row++ = *s++;
		}
		*row = 0;
		return row;
	}
#else
	u8 *s, *d;
	if (num == 0){
		if(myStreams[0].rxPipe.val>0) s = myStreams[0].rxPipe.val;
		else return row;
	}
	else if (num > maxRowN) { toP0((u8*) "Error no row %j", 0, num); err = 1; return row; }
	else s = m_program[num];											/// source pointer
	d = row;
	while (*s == ' ' || *s == 9) s++;									// skip leading spaces and tabs
	while (*s && *s!='\r'){
		if (*s == '#') {
			while (d >= row && (*(d-1) == ' ' || *(d-1) == 9)) d--;				// skip trailing spaces and
			break;
		}
		*d++ = *s++;
	}
	*d = 0;
	return row;
#endif
}

//--------------------------------------------------------------------------------------------------------------------------------------------
void ICACHE_FLASH_ATTR setDT(){								/// processor specific prg to set RealTimeClock
}
//--------------------------------------------------------------------------------------------------------------------------------------------
void ICACHE_FLASH_ATTR updateDT(){							/// processor specific prg to get RealTimeClock
    volatile u8 *d=&myDate[4];
    const char month_table[13]={0,31,28,31,30,31,30,31,31,30,31,30,31};			// common month table
    (*d)++;
    if(*d==60){
        *d=0;
        d--;
        (*d)++;
        if(*d==24){                             // if h=24h
            u8 m=month_table[myDate[1]];
            if(m==28 && ((myDate[0] % 4)==0))m++;
            *d=0;
            d--;
            (*d)++;
            if(*d>m){
                *d=1;
                d--;
                (*d)++;
                if(*d==13){
                    *d=1;
                    d--;
                    (*d)++;
                }
            }
            myDate[6]=dayofWeek(myDate[0],myDate[1],myDate[2]);
        }
    }
}

/**===============================================================================================
	INTEFACES AND INTERFACE FUNCTIONS IN SEPARATED FILES!
=================================================================================================*/

