/**
 * Processor specific programs to handle all the peripherals. This file should be rewritten for a different processor from those
 *
 * who knows how things happens
 -------------------------------------------------------------------------------------------------------------------------------------------*/
#ifndef MULE_2_USER_ESPPROCESSORSPECIFIC_H_
#define MULE_2_USER_ESPPROCESSORSPECIFIC_H_
#include <c_types.h>
#include <eagle_soc.h>
#include "globals.h"

#define	versionSW	1							// SoftWare version
#define versionHD	7							// Hardware version ESP-07. Affects pin available
#define subversion	9							// sub-version : replace this!

//#define USE_ROM_PRG
#define USE_RAM_PRG
//#define USE_PING_PONG							/// associate Rx&Tx buffers as PingPong buffers for fast file transfer, usually if ROM PRG

#define RANGE u16								/// max index range of all var's, timers e.t.c. It's very natural to set to processor architecture, but consumes more RAM
#define PIPE_COUNT	5							/// Pipes count in each interface

#define M_ROWS	1024							/// mule program max row count (0 row empty, so 128 available)

// File System set
#define roEMPTY		0xff						/// read value of an empty flash cell
#define NAME_LEN	11							/// incl. \0
#define FS_SIZE 			65536				/// file system size max used memory	64k
#define BLOCK_SIZE			4096				/// min erase size block
#define PAGE_SIZE			256					/// one page size i.e. 256 pages in 64k. No more or pageN: will exit 0xff!
#define FILE_NUM 			(sizeof(RANGE)*8)	/// max file number if RANGE=u16 =16 -> 0- dir, 1...15- files
#define FAT_SECTOR			0x10				/// File system start sector
#define FAT_ADDRESS			0x10000				/// File system start address

u32 me_correct = FAT_ADDRESS % 0x1000;			// integer correction if Start FS Address not on the beginning of a sector (usually 0)

//u8 __attribute__((section ("FS"))) buf[FS_SIZE] __attribute__ ((aligned (BLOCK_SIZE)));

/** Current state of the intreface.*/

typedef struct {										// KEEP THIS 4 byte alligned!
	u8 name[NAME_LEN];
	u16 length;
	u16 checksum;
	struct{						// TODO
		u8 state : 4;
		u8 flags : 4;
	}attr;
}t_file;

typedef struct{						// TODO
	u8 state : 4;
	u8 flags : 4;
}attr;

//********************************************************************************/
//* FAT : File allocation Table
//* Description  : consist of FILE_NUM t_file Labels. Next follow FILE_SYSTEM_SIZE/PAGE_SIZE bytes PAGE_MAP
//* Parameters   : ex: 15 files*17 label_len=255 bytes+ 64k/256=256 bytes = 511 bytes
//* BLOCK and SECTOR same meaning!
//*******************************************************************************/
#define FAT_TABLE_LEN 	(FILE_NUM*sizeof(t_file))							// start gap of PAGE_MAP	=255
#define FAT_MAP_LEN		(FS_SIZE/PAGE_SIZE)									// number of pages in FS	=256
#define FAT_PAGES_USED	((u8)((FAT_TABLE_LEN + FAT_MAP_LEN+PAGE_SIZE-1)/PAGE_SIZE))				//	=2
#define SECTOR_LIMIT	(FS_SIZE/BLOCK_SIZE+FAT_SECTOR)						// 1-st sector after FS to check for limit =0x20

static t_file FATtable[FILE_NUM] = { roEMPTY };								/// if RANGE u16 => max 15 files
static u8	 FATmap[FAT_MAP_LEN] = { roEMPTY };								/// represents file pages used in ROM

#define my_reboot()		system_restart()
#define my_malloc(a)	os_malloc(a)
//#define os_memcpy(...) memcpy(__VA_ARGS__);
#define my_free(a)	os_free(a)
//#define os_memset(...)	memset(__VA_ARGS__);
//#define u8 spi_flash_read(u32 source_address, u32 *dest_p, u32 len);
//#define void spi_flash_erase_sector(u16 sector);
//#define void spi_flash_write(u32 dest_address, u32 *source_p, u32 len)

// From ESPProcessorSpecific.c

void 	HDinit();
BOOL 	setOuts(u8);
BOOL 	setIns(u8);
void 	initAnalogs();
BOOL 	setAnalog();
void 	doIns();
void 	doOuts(u8);
void 	writeMProgram();
u16		readMProgram();
void	setDT();
void	updateDT();
void 	initSerial(u8, u8*);
void	initWiFi(u8, u8*);
void	initDevice(u8, u8*);
void	openFile(u8, u8*);
u16 	toP0(u8 *q, u8 i, s16 j);
void	clearPx(u8);
u8*		loadRow(u16);

/**
 *  Processor descriptors
 */
typedef s32 ALL_TYPE;
ALL_TYPE ALLINs[16];
ALL_TYPE ALLOUTs[16];
ALL_TYPE ALLANGs[1];	                				/// all analog input available pins

/// Here put all processor interfaces init functions you have. If the list of interfaces don't cover all the interfaces you have
/// just extend list adding interface init fun in list here and declare it above, then write subroutines, using an existing interface as pattern
#define FOpen	6							// index of openFile program in allInterfacesByType used in mule to read/write files
void(*allInterfacesByType[])(u8, u8*)={0,initSerial,0,0,0,initWiFi, openFile,0,0, initDevice};

//u8 myADCchannel;										/// analog channel select (if applicable for processor ADC hardware)
// we use =-1 here to indicate a unassigned pin because of GPIO_0 in ESP8266. This cause a limit of 128 pins incl. pin0.
// Normally pin numbers start from 1 and =0 will work fine giving us 255 pins to use.
// However - leave this as is or you will have trouble with pin assignments in muleSentence() for example for input pins:
// for (i = 1; inputPins[i] >= 0; i++) then must be
// for (i = 1; inputPins[i] > 0; i++) Same for ouputPins and analogPins
static s8 inputPins[sizeof(RANGE)*8]={-1};      		// holds real pin mapped to ... ,I5,I4,I3,I2,I1,I0 in mule
static s8 outputPins[sizeof(RANGE)*8]={-1};     		// holds real pin mapped to ... ,O3, O2, O1, O0
static s8 analogPins[sizeof(RANGE)*8]={-1};				// holds real pin mapped to ... ,A3,A2,A1,A0

#endif
