/*
 * globals.h
 *	Global definitions for ml machine
 *  Created on: 17.02.2015 .
 *      Author: Svetlin
 */

#ifndef USER_GLOBALS_H_
#define USER_GLOBALS_H_

#include "ProcessorSpecific.h"
#include <c_types.h>
/**------------------------------------------------------------------------------------------------------------------------------------------
* 	You may use such macros instead of bitoperate functios, to save stack instead program memory
#define bitset(var, bitno) ((var) |= 1UL << (bitno))
#define bitclr(var, bitno) ((var) &= ~(1UL << (bitno)))
#define bitxor(var, bitno) ((var) ^= 1UL << (bitno))
#define bitchk(var, bitno) ((var & (1UL << (bitno))) ? TRUE:FALSE)
*/
//#define RANGE u16							/// max index range of all var's, timers e.t.c. It's very natural to set to processor architecture, but consumes more RAM
#define DEL ','								/// Use this as Command delimiter in ml program
BOOL ME_BUSY=FALSE;
u8 err;										/// holds error N: if any in mumps
u16 m_len;									/// mule Program length in bytes
u16 maxRowN=0;								/// current prg row count
u8 load_interface;							/// interface current booked to load a file

#ifdef USE_ROM_PRG
    const u8 *m_Buffer; //@0x1c00;			/// mule Program buffer container in ROM
	const u8 *m_program[M_ROWS]={0};    	/// mule program row pointers. Holds the beginning address of each row
    u32 indx;								/// holds last written address in flash
#else
    //u8 *m_Buffer, *temp_Buffer;             /// mule Program buffer container in RAM
    u8 *m_program[M_ROWS];            		/// mule program row pointers
    u8 *h;									/// holds last written address in flash; used by readProgram too
#endif

union{
	u8 value;
	struct{
        u8 E : 1; // END flag
        u8 B : 1; // BREAK flag
        u8 S : 1; // STEP flag
        u8 C : 1; // CONTINUE flag
        u8 T : 1; // TIMERS_STOP flag-free
        u8 L : 1; // LOAD_mPROGRAM
        u8 R : 1; // READ goes
        u8 M : 1; // file mode load 0- as is, 1- strip garbage
	} f;
} static mode;

/* A demo m_program
    "I(40),O(11,12)\r",               // pin2 input0, pin 3 output0
	 "O0=0,O1=1\r",
    "T1(10,0,1)\r",
    "M\r",
    "?T1,T1(10,0,1),O0=^,O1=^,P1\r",  //X1\r",
    "E\r"
};
*/

//=============================================================================
//		GLOBAL VARs
//-------------------------------------------------------------------------------


typedef struct {                  	/// Describes one Timer.
    u16 value:15;                   /// Current timer value (counts down).
    u16 sek:1;                     	/// timer source 0=mSec, 1=Sec
    }timer;

#define MAX_L$ 256             		/// max String length. For 8-bit words =256; for 16-bit words=512
#define MAX_BUFFER 512				/// max Pipe Buffer size  For 8-bit words =256; for 16-bit words=512
#define INTERFACES_NUM (sizeof(RANGE)*8+1)


typedef struct{						/// Type 't_String' definition
	u16 len;
	u8 val[MAX_L$];
}t_String;


typedef struct{						/// Type 't_Buffer' definition
	u16 len;
	u8  val[MAX_BUFFER];
}t_Buffer;

typedef struct{
	t_Buffer *r;					/// used when openPipe uses os_malloc to hold os_free argument, else comment
	u16* len;
	u8 * val;
}p_Buffer;

struct{
	s8 pipe_count;							/// counts how many pipes with same index exist to decide when to free a pipe buffer
	p_Buffer rxPipe;
	p_Buffer txPipe;
} static myStreams[INTERFACES_NUM] = {0};		 /// Array of Pipe's buffers for send/receive +1 for load file

struct{
	u8 intf;								/// interface causing rock
	u8 i_pipe;								/// pipeAttached in those intf
}ReqPipe0;

/** Current state of the intreface.*/
enum intf_state {
	INTF_CLOSE,
	INTF_CREATE,
	INTF_OPEN,
	INTF_CONNECT,
	INTF_ERR,
	INTF_DISCONNECT
};

struct{
	u8 state;								/// all Interfaces state
	u8 type;
	u8 subtype;
	u8 id;
	u8 pipes_attached;
	void(*openPipe)(u8, u8, u8*);			/// pointer to void openPipe(pipe, intf_num, u8* params)
	void(*closePipe)(u8, u8);				/// pointer to void closePipe(pipe, intf_num)
	void(*sendInterface)(u8);				/// pointer to void sendInterface(intf_num)
	void(*closeInterface)(u8);				/// pointer to void closeInterface(intf_num)
}volatile myInterfaces[INTERFACES_NUM]={0};		/// collection of all the processor interfaces available
// Interface0 is console
// Interface[sizeof(RANGE)*8+1] is download dediceted and need to be resized
struct{
	u8* ping;								// just one active instant, switches to other when file resize
	u8* pong;
}static fileMountAddress[INTERFACES_NUM] = {0};							/// fill in when a file open or create to direct the Pipes to it

static u16	fileSize[INTERFACES_NUM] = { 0 };							/// holds current malloc size of a file

volatile u8 myDate[7];
//volatile gu8 DY=0;								/// __DY__ DataTime Year	00...99 (2000..2099)
//volatile gu8 DM=0;								/// __DM__ DataTime Month	1...12
//volatile gu8 DD=0;								/// __DD__ DataTime Day 1...31
//volatile gu8 Dh=0;								/// __Dh__ DataTime hour  0...23
//volatile gu8 Dm=0;								/// __Dm__ DataTime min  0...59
//volatile gu8 Ds=0;								/// __Ds__ DataTime sec 0...59
//volatile gu8 DW=0;								/// __DW__ DataTime DayofWeek 0...6 (Sun...Sat)


/*----------------------------------
 * USED BY FUNCTIONS IN MUMPS DECODE
 * -------------------------------*/
#define NUM_TASK 8									/// Number of different mlTasks available

volatile timer allTimers[sizeof(RANGE)*8+NUM_TASK];  /// 8*sizeof(RANGE) timer structures+tasks halt timers+pipe timers
volatile s16 myVars[sizeof(RANGE)*8];               /// 8*sizeof(RANGE)  myVars V0..V16 16 bit signed
volatile s16 myAnalogs[sizeof(RANGE)*8];            /// 8*sizeof(RANGE) myAnalogs A0--A7

//u8 myADCchannel;                           		/// current ADC channel if applicable!!!

volatile RANGE myPipes;								/// bool Pipes State (0-closed,nok,busy; 1-open,OK)
volatile RANGE myFlags;                    			/// boolean Flags. Index from 0 to 8*sizeof(RANGE)-1
volatile RANGE myTimers;                   			/// all Timers Flags. Index from 0 to 8*sizeof(RANGE)-1 fire T 0...7
volatile RANGE myIns;                      			/// all Inputs. Index from 0 to 8*sizeof(RANGE)-1.  Value of corresponding input bit0->I0, bit1->I1 ...
volatile RANGE myOuts;                     			/// all Outputs. Index from 0 to 8*sizeof(RANGE)-1
volatile u8 halt;
/*
 struct {
    u8 H0 : 1; // HALT Task0
    u8 H1 : 1; // HALT Task1
    u8 H2 : 1; // HALT Task2
    u8 H3 : 1; // HALT Task3
    u8 H4 : 1; // HALT Task4
    u8 H5 : 1; // HALT Task5
    u8 H6 : 1; // HALT Task6
    u8 H7 : 1; // HALT Task7
}
 * */

t_String my$[sizeof(RANGE)*8];        		/// User strings each 256 chars long (MAX_L$)

//* Used from different Subs

/// From math$Expression
t_String out$;								/// Return string from do$Ex
s16 result;									/// Retun result from &Ex()
u8 inString[MAX_L$]; // @ 0x20C0;			/// String to pass to math$Expression prg.

/// From uart.c



// From MySubroutines.c
void	bitset(volatile RANGE *f,u8 b);
void	bitxor(volatile RANGE *f,u8 b);
BOOL	bitchk(volatile RANGE *f,u8 b);
void	bitclr(volatile RANGE *f,u8 b);
u8 		dayofWeek(u8 yy, u8 mm, u8 dd);
u16		my_strlen(u8 *p);
s16 	indexE(u8 **pn, u8 i_base);
bool    help(u8* pp, const char * hp);
void 	fl_memcpy(u8 *p1, u8 *p2,RANGE len);
u8 		my_sprintf(u8 *p, u8 *q, u8 i, s16 j);
u16 	removeLeading(u8 *p);
void 	cutString(u8 *my, u8 *out, u16 outlen);
void 	add_char(u8 *MyString, char MyChar);
u8* 	find_char(u8 *MyString, char MyChar);
u8* 	my_strstr(u8 *p, u8 *q);


// From math$Expressions.c
s16 	$Ex(u8*);									/// common entry point to math$Expression. Inits all the tables
s16 	do$Ex(u8 *);								///	Internal entry point to math$Expression, which not inits the work variables (recursive call from inside math$Expression)

// From mule.c
BOOL 	muleInit(void);							/// call when initialise MUMPS at start/restart
u16		rock(u8);
u8 		mule(void);								/// call from main at last once per mS or in Interrupt after doTimers()
void 	doTimers(void *arg);					/// Must be called in Interrupt manier every .25 mS

// From File System
void 	initFS();
#endif /* USER_GLOBALS_H_ */
