#include "globals.h"

/*
* File:   mathExpressions.c
* Author: Svetlin
*
* Created on ??????, 2014, ??? 1, 8:27
*/


//#include "fl_type.h"
//#include "mathExpressions.h"
//#include "globals.h"

/**
* To use this program everywhere simply pass a string in inString
* You have to replace var names in
*              case 'V':
*              case 'A':
*              case 'T':  {p1=&(myTimers.Value);goto Lab1;}
*              case 'F':  {p1=&(myFlags.Value);goto Lab1;}
*              case 'I':  {p1=&(myIns.Value);goto Lab1;}
*              case 'O':  {p1=&(myOuts.Value);}
*              case 'D':
* My vars are in format V1,A2,..V24 i.e. single char and number. T,F,I,O are bit flags i.e.=1 or 0
* inString is limited to 30 chars, converted string String[24],
* BraStr[24] holds a in-bracket expression,
* Val[16] holds the signed actual value of chars in String[]
*/
//char inString[]="(-4*V1)+(-(V2+12)+10)";
#define maxEChars	25								// use max 25 Vars A,B, ... Z, but no more than 32!
#define max$Chars	16								// use max 16 Strings if RANGE=u16, but no more than 30!

#define	$_char		('a'+128)						// to escape from traditional chars
#define min_$		 ($_char-1)						// so check if > min_$
#define max_$		 ($_char+max$Chars+1)				// check if < max_$


#define val_char	('A'+128)
#define min_v		(val_char-1)					// so check if > min_v
#define max_v		(val_char+maxEChars+1)			// check if < max_v

u8 nextChar = val_char;
u8 next$har = $_char;

s16 Val[maxEChars];// @0x20D2;
//-------------------------------
// $ definitions
t_String work$[max$Chars] = { 0, 0 };				// used by mathExpression for string operations. No more than 26!
struct{
	u16 *$p_len;									// points to len
	u8	*$p_val;									// points to val
} table[max$Chars] = { NULL, NULL };				// holds pointer to strings in user$, work$ and files

u8 wIndex = 0;                                      // index where to write next work$

/**-------------------------------------------------------------------
	PROGRAM THAT DOES CALCULATIOS OVER AN EXPRESSION WITH NO BRACKETS |
----------------------------------------------------------------------*/

u8 noBracket(u8* b,BOOL no$){
	s16 rez = 0;
	RANGE i = 0, j = 0, len;
	s16 ar[maxEChars] = { 0 };
	u8 *h, *p = b;
	RANGE newLen = my_strlen(b), oldLen;
	// Process $
	if (no$) goto DoMath;

	// MAIN LOOP
	do{
Lab_1:
		oldLen = my_strlen(b);
		if (oldLen == 1) break;
		if (*p < max_$ && *p>min_$){			// found 'a,b,..'
			i++;
			h = p + 1;				// help *
			if (h >= (b + oldLen))  break;
			switch (*h){
			case '[':{	///$1[3 will return a $ containing elements 1 and 2, so $1[1 will return 0
				h++;
				if (*h > min_v && *h < max_v){		// if 'A,B..'
					s16 dif = Val[*h - val_char];
					//if (dif < 0) dif = -dif;
					if (dif < 2) { work$[wIndex].len = 0; work$[wIndex].val[0] = 0;}
					else if (dif <= *table[*p - $_char].$p_len){
								work$[wIndex].len = dif - 1;
					}
					else work$[wIndex].len = *table[*p - $_char].$p_len;
				}
				else if (*h == '+' || *h == '-' || *h == '*' || *h == '/' || *h == 0 || *h == ']'){		// a new operation found, so current means need to cut trailing
					work$[wIndex].len = *table[*p - $_char].$p_len;
					h--;										// point over '['
					while (table[*p - $_char].$p_val[work$[wIndex].len - 1] < 0x20 && work$[wIndex].len) work$[wIndex].len--;
				}
				else{
					p = h; goto Lab_1;
				}
				table[next$har - $_char].$p_len = &work$[wIndex].len;
				table[next$har - $_char].$p_val = table[*p - $_char].$p_val;				// same string different lenght
				wIndex++;																	// next work$
				*p = next$har++;															// next char
				while (*++h){																	// copy else to the end of sentence
					*++p = *h;
				}
				*++p = 0;
				p = b;
				goto Lab_1;
			}
			break;
			case ']':{		///$1]3 will return a $ from 3 incl. to the end, so $1]_$1 will return the last element
				s16 dif = 0;
				h++;
				if (*h > min_v && *h < max_v){		// if 'A,B..'
					dif = Val[*h - val_char];
					//if (dif < 0) dif = -dif;
					if (dif < 1 || dif > *table[*p - $_char].$p_len) {		// if <=0
						work$[wIndex].len = 0;
						work$[wIndex].val[0] = 0;
						table[next$har - $_char].$p_val = work$[wIndex].val;
					}
					else {
						work$[wIndex].len = *table[*p - $_char].$p_len - dif + 1;
						table[next$har - $_char].$p_val = table[*p - $_char].$p_val + dif - 1;
					}
				}
				else if (*h == '+' || *h == '-' || *h == '*' || *h == '/' || *h == 0 || *h == '['){		// a new operation found, so current means need to cut leading
					h--;													// point over ']'
					while (table[*p - $_char].$p_val[dif] < 0x20 && *table[*p - $_char].$p_len > dif) dif++;
					work$[wIndex].len = *table[*p - $_char].$p_len-dif;
					table[next$har - $_char].$p_val = table[*p - $_char].$p_val + dif;
				}
				else{
					p = h;
					goto Lab_1;
				}
				table[next$har - $_char].$p_len = &work$[wIndex].len;
				wIndex++;												// next work$
				*p = next$har++;										// next char
				while (*++h){											// copy else to the end of sentence
					*++p = *h;
				}
				*++p = 0;
				p = b;
				goto Lab_1;
			}
			break;
			case '+':{
				h++;
				if (*h < max_$ && *h>min_$){						// if a+b
					RANGE mylen = *table[*p - $_char].$p_len + *table[*h - $_char].$p_len;
					table[next$har - $_char].$p_val = work$[wIndex].val;
					table[next$har - $_char].$p_len = &work$[wIndex].len;
					if (mylen > MAX_L$){
						work$[wIndex].len = MAX_L$;
						mylen = MAX_L$ - *table[*p - $_char].$p_len;
					}
					else{
						work$[wIndex].len = mylen;
						mylen = *table[*h - $_char].$p_len;
					}
					fl_memcpy(work$[wIndex].val, table[*p - $_char].$p_val, *table[*p - $_char].$p_len);
					fl_memcpy(work$[wIndex].val + *table[*p - $_char].$p_len, table[*h - $_char].$p_val, mylen);
					//for (i = 0; i < work$[wIndex].len; i++){
					//	work$[wIndex].val[i] = (i < table[*p - $_char]->len) ? table[*p - $_char]->val[i] : table[*h - $_char]->val[i - table[*p - $_char]->len];
					//}
					wIndex++;										// next work$
					*p = next$har++;								// next char
					while (*++h){									// copy else to the end of sentence
						*++p = *h;
					}
					*++p = 0;
					p = b;
					goto Lab_1;
				}
				p = h; goto Lab_1;
			}
			break;
			case '*':{
				h++;
				if (*h < max_v && *h > min_v){							// if a*A
					if (Val[*h - val_char] == 0) p -= 2;				// p points on 'a', h on 'A'(=0), so remove sign befor 'a' and copy all after 'A'
					while (*++h){										// copy else to the end of sentence
						*++p = *h;
					}
					*++p = 0;
					p = b;
					goto Lab_1;
				}
				p = h; goto Lab_1;
			}
			break;
			case '=':{
				h++;
				if (*h < max_$ && *h>min_$){						// if a=b =are strings equall?
					u8 j = 0;
					if (*table[*p - $_char].$p_len == *table[*h - $_char].$p_len){
						for (i = 0; i < *table[*p - $_char].$p_len; i++){
							if (table[*p - $_char].$p_val[i] != table[*h - $_char].$p_val[i]) break;
						}
						if (i == *table[*p - $_char].$p_len) j = 1;
					}
					*p = nextChar;
					Val[nextChar - val_char] = j;
					nextChar++;
					while (*++h){										// copy else to the end of sentence
						*++p = *h;
					}
					*++p = 0;
					p = b;
					goto Lab_1;
				}
				p = h; goto Lab_1;
			}
			break;
			case '/':{
				h++;
				if (*h < max_$ && *h>min_$){						// if a/b =where in a is b
					BOOL OK = FALSE;
					j = 0;
					i = 0;
					s16 dif = 1 + *table[*p - $_char].$p_len - *table[*h - $_char].$p_len;
					if (dif>0){
						for (i = 0; i < dif; i++){
							for (j = 0; j < *table[*h - $_char].$p_len; j++){
								if (table[*p - $_char].$p_val[i + j] != table[*h - $_char].$p_val[j]) break;
							}
							if (j == *table[*h - $_char].$p_len) { OK = TRUE; break; }
						}
					}
					if (OK) i += *(table[*h - $_char].$p_len)+1;			// i++;
					else i = 0;
					*p = nextChar;
					Val[nextChar - val_char] = i;
					nextChar++;
					while (*++h){											// copy else to the end of sentence
						*++p = *h;
					}
					*++p = 0;
					p = b;
					goto Lab_1;
				}
				else if (*h < max_v && *h>min_v){																// if a/A =ASCII at position A
					if ((Val[*h - val_char]) > 0 && Val[*h - val_char] < (*table[*p - $_char].$p_len + 1)){		//dimension check
						Val[nextChar - val_char] = table[*p - $_char].$p_val[Val[*h - val_char] - 1];
					}
					else Val[nextChar - val_char] = 0;
					*p = nextChar;
					nextChar++;
					while (*++h){											// copy else to the end of sentence
						*++p = *h;
					}
					*++p = 0;
					p = b;
					goto Lab_1;
				}
				else p = h; goto Lab_1;
			}
			break;
			default:{
				p++;
			}
			break;
			}

		}
		else if (*p < max_v && *p > min_v){										// chack if A*a+
			h = p + 1;
			if ((*h == '*') && (*(h + 1) < max_$ && *(h + 1) > min_$)){
				if (*(h + 2) == '+' || *(h + 2) == '\0'){
					//if (Val[*h - val_char] == -1)									// if -1*$ may be I added, so first process string expression after *
					h++;
					if (Val[*p - val_char] != 0) *p = *h;						// p points on 'A', h on 'a'(=0), so replace 'A' with 'a' and copy all after 'A'
					while (*++h){												// copy else to the end of sentence
						*++p = *h;
					}
					*++p = 0;
					p = b;
					goto Lab_1;
				}
				else{
					p += 2;
				}
			}
			else {
				p ++;
			}
		}
		else if (*p == '_'){
			h = p + 1; //h++;
			if (*h < max_$ && *h > min_$){							// if _a return len of a
				Val[nextChar - val_char] = *table[*h - $_char].$p_len;
				*p = nextChar;
				nextChar++;
				while (*++h){										// copy else to the end of sentence
					*++p = *h;
				}
				*++p = 0;
				p = b;
				goto Lab_1;
			}
			else p = h; goto Lab_1;
		}
		else p++;
		newLen = my_strlen(b);
	} while (oldLen != newLen || *p != '\0');

	if (oldLen == 1)											// if single char left
	{
		if (*b < max_$ && *b > min_$) return next$har - 1;		// return 'a','b' etc
		else return (*b);										// if 'A','B' etc
	}

	for (p = b; p <b + newLen; p++){							// check if no more 'a','b' etc
		if (*p < max_$ && *p > min_$) {								// if YES replace with int($)
			u8 *q = table[*p - $_char].$p_val;
			*(table[*p - $_char].$p_val + *table[*p - $_char].$p_len) = '\0';
			Val[nextChar - val_char] = indexE(&q, 10);
			*p = nextChar;
			nextChar++;
		}
	}
	//=====================================================================================
DoMath:
	p = b;
	len = my_strlen(b);
	for (i = 0; i<len; i++){
		switch (*(p + i)){
		case '+':{
			ar[j] = rez;
			j++;
		}
			break;
		case '*':{
			u8 index = *(p + i + 1) - val_char;     // ASCII A
			rez *= Val[index];
			i++;
		}
			break;
		case '/':{
			u8 index = *(p + i + 1) - val_char;     // ASCII A
			if (Val[index] != 0)rez /= Val[index];
			else rez = 0x7fff;
			i++;
		}
			break;
		case '>':
		{
			u8 index = *(p + i + 1) - val_char; // ASCII A
			if (rez > Val[index]) rez = 1;
			else rez = 0;
			i++;
		}
			break;
		case '<':
		{
			u8 index = *(p + i + 1) - val_char; // ASCII A
			if (rez < Val[index]) rez = 1;
			else rez = 0;
			i++;
		}
			break;
		case '=':
		{
			u8 index = *(p + i + 1) - val_char; // ASCII A
			if (rez == Val[index]) rez = 1;
			else rez = 0;
			i++;
		}
			break;
		case '&':{
			u8 index = *(p + i + 1) - val_char;     // ASCII A
			rez &= Val[index];
			i++;
		}
			break;
		case '|':{
			u8 index = *(p + i + 1) - val_char;     // ASCII A
			rez |= Val[index];
			i++;
		}
			break;
		case '^':{
			u8 index = *(p + i + 1) - val_char;     // ASCII A
			rez ^= Val[index];
			i++;
		}
			break;
		default:{
			if (*(p + i) != ' '){
				u8 index = *(p + i) - val_char;
				rez = Val[index];  //from ASCII casting index to Var
			}
			else continue;
		}
			break;
		}
	}
	// rez holdsin the last one diggit, so dont clear
	for (i = 0; i<j; i++){
		rez += ar[i];
	}
	Val[nextChar - val_char] = rez;
	nextChar++;
	return (nextChar-1);
}


s16 do$Ex(u8 *p0){
	/**
	*	MAIN ENTY POINT
	* From expression $1]+"..text.."+$2xV1+$(Ex) composes string
	* a]+b+c+d where a,b,c,d are pointers to work$ array
	*/

	BOOL no$ = TRUE;								// if inString does not contain $ operations scip some passages
	u8 String[MAX_L$];
	u8 BraStr[MAX_L$];//@0x20BE;					// represent a string from inString in brackets
	u8 *p1 = BraStr;								// working over BraStr will produce new string ower BraStr
	u8 *p2 = p0;
	volatile RANGE* varP;
	char minus = 0;									// if FALSE means plus
	// GET READY
	do{												// copy inString to String
		if (*p0 == '$' || *p0 == '"') no$ = FALSE;
		*p1++ = *p0++;
	} while (*p0);
	*p1 = 0;
	if (no$)	goto PrepareMath;
	p1 = BraStr;
	p0 = p2;
	out$.len = 0;

	/**------------------------
	// START STRING COMPOSE
	--------------------------*/
	while (*p0>0){
		static BOOL CHR=TRUE, UP_C=FALSE;
		static u8 d_len=0, base=10;
		u8 i;

		u8 *t;					// pointer to work$ val
		u16 *tlen;

		t = work$[wIndex].val;						// pointer to work$ val
		tlen = &work$[wIndex].len;
		*tlen = 0;
		if (*p0 == 34){                             // case "..text.."
			//t = work$[wIndex].val;					// pointer to work$ val
			//tlen = &work$[wIndex].len;
			//*tlen = 0;
			p0++;
			while (*p0 != 34 && *p0 != 0)	{
				if (*p0 == 92){						// if '\'
					p0++;
					if (*p0 == 'r') {*t++ = 13;	p0++;}			// '\r'
					else if (*p0 == 'n') { *t++ = 10; p0++; }	// '\n'
					else {
						*t++ = *p0++;
					}
					(*tlen)++;
				}
				else if (*p0 == '%'){
					u8 dig1;
					p0++;
					d_len = indexE(&p0, 10);							// desired digit len
					dig1 = d_len;
					//RANGE s16 dig2 = 0;
					if (*p0 == 'a'){ CHR = TRUE; p0++; }
					else { CHR = FALSE; }
					if (*p0 == 'x') { base = 16; UP_C = FALSE; }
					else if (*p0 == 'X') { base = 16; UP_C = TRUE; }
					else if (*p0 == 'd') base = 10;
					{
						bool doCycle = FALSE;
						p0++;
						if (*p0 == '{'){
							doCycle = TRUE;
							p0++;
						}
						do
						{
							if (*p0 == DEL){ p0++; }
							else{
								u8 myVal[7] = { 0 },i;
								dig1 = i_to$(myVal, Ex(&p0, (doCycle) ? 253 : 162), base, CHR, UP_C, d_len);			// in msg ends 128+'}' or 128+'"'
								*tlen += dig1;
								for (i = 0; i < dig1; i++){
									*t++ = myVal[i];
								}
							}
						} while (doCycle && *p0 != '}' && *p0 != 0);

						if (*p0 == DEL || *p0 == '}') p0++;
					}
				}
				else{
					*t++ = *p0++;
					(*tlen)++;
				}
			}
			table[next$har - $_char].$p_len = &work$[wIndex].len;
			table[next$har - $_char].$p_val = work$[wIndex].val;
			wIndex++;                               // next work$
			*p1++ = next$har++;                       // next char
			if(*p0) p0++;
		}
		else if (*p0 == '$'){                          // case $1,${Ex},$4x{Ex},$2ax{Ex},$2d{Ex}
			p0++;
			if (*p0 == 'P'){											// case Pipe;
				u8 dig1, i;
				p0++;
				dig1 = indexE(&p0, 138);
				if (bitchk(&myPipes, dig1)){
					table[next$har - $_char].$p_len = myStreams[dig1].rxPipe.len;									// not transfer, but set pointer to pipe
					table[next$har - $_char].$p_val = myStreams[dig1].rxPipe.val;									// so we can use a very large pipe if finely cut less than MAX_L$
				}
				else{
					work$[wIndex].len =  0;																			// if pipe closed
					table[next$har - $_char].$p_len = &work$[wIndex].len;
					table[next$har - $_char].$p_val = work$[wIndex].val;
				}
				wIndex++;													// next work$
				*p1++ = next$har++;											// replace 'P' with next char
			}
			else
			{
				u8 dig1 = indexE(&p0, 138);
				table[next$har - $_char].$p_len = &my$[dig1].len;					// case $1
				table[next$har - $_char].$p_val = my$[dig1].val;
				wIndex++;
				*p1++ = next$har++;
			}
		}
		else {
			*p1++ = *p0++;
		}
	}
	*p1 = '\0';


	/**PREPROCESS MATH EXPRESSION
	*
	* from inString compozes String (A*B)+((C)*(D+E)+F)) and fills Val[0..5] with signed values
	* Letters and Val[..] will expand, depending of number of brackets
	*/

PrepareMath:
	p0 = BraStr;
	p1 = String;
	p2 = String;
	minus = 0;          // means plus

	while (*p0){
		if (*p0 > 0x2f && *p0 < 0x3a){
			u16 dig = indexE(&p0,10);
			if (dig == 0){
				if (*p0 == 'x'){
					p0++;
					dig = indexE(&p0, 16);
				}
				else{
					dig = indexE(&p0, 10);
				}
			}
			Val[nextChar - val_char] = (minus) ? -dig : dig;     //A->Val[0], B->Val[1],
			*p2++ = nextChar++;           // A,B,C,..
		}
		else{
			switch (*p0){
			case '-':{
				if (*(p0 + 1) == '(' || *(p0 + 1) == '_' || (*(p0 + 1)>min_$ && *(p0 + 1) < max_$)){                       // if -(..) or -$ transform to -1*(..)
					*p2++ = '+';
					*p2++ = nextChar;
					Val[nextChar - val_char] = -1;
					nextChar++;
					*p2++ = '*';
					minus = 0;
				}
				else{
					*p2++ = '+';
					minus = 1;
				}
				p0++;
			}
				break;
			case '+':				/// __Operations permissed: +, -, *, /, >, <, = (means ifequall)
			case '*':
			case '/':
			case '(':
			case ')':
			case '>':
			case '<':
			case '=':
			case '&':
			case '|':
			case '^':
			case '[':
			case ']':{
				*p2++ = *p0++;
				minus = 0;
			}
			break;
			case '_':{
				if (*(p0 + 1) == 'T'){
					u8 i;
					p0 += 2;
					i = indexE(&p0, 10);
					Val[nextChar - val_char] = allTimers[i].value/4;		// always positive as we transform '-_xx' to (-1)*_xx
					*p2++ = nextChar++;
				}
				else if(*(p0 + 1) == 'P'){
					u8 i;
					p0 += 2;
					i = indexE(&p0, 10);
					if(myStreams[i].txPipe.len>0) Val[nextChar - val_char] = *myStreams[i].txPipe.len;	// always positive, see above comment
					else Val[nextChar - val_char] = 0;
					*p2++ = nextChar++;
				}
				else *p2++ = *p0++;
				minus = 0;
			}
				break;
			case 'V':{
				u8 i;
				p0++;
				i = indexE(&p0,138);
				Val[nextChar - val_char] = (minus) ? -myVars[i] : myVars[i];
				*p2++ = nextChar++;
			}
				break;
			case 'A':{
				u8 i;
				p0++;
				i = indexE(&p0,138);
				Val[nextChar - val_char] = (minus) ? -myAnalogs[i] : myAnalogs[i];
				*p2++ = nextChar++;
			}
				break;
			case 'D':
			{
				u8 i;
				p0++;
				i = indexE(&p0,138);
				Val[nextChar - val_char] = (minus) ? -myDate[i] : myDate[i];
				*p2++ = nextChar++;
			}
				break;
			case 'U':{
				u16 i;
				u8 val;
				p0++;
				i = indexE(&p0, 138);
				val = myInterfaces[i].state;
				Val[nextChar - val_char] = (minus) ? -val : val;
				*p2++ = nextChar++;
				minus = 0;
			}
				break;
			case 'T':  {varP = &(myTimers); goto Lab1; }                        // convert Bool to s16= 0 or1
			case 'F':  {varP = &(myFlags); goto Lab1; }
			case 'I':  {varP = &(myIns); goto Lab1; }
			case 'O':  {varP = &(myOuts); goto Lab1;}
			case 'P':  {varP = &(myPipes);}
			Lab1:           {
				u16 i = 0;
				RANGE val;
				p0++;
				if ((*p0 > 0x2f && *p0 < 0x3a) || *p0=='('){									// ex: if I1,I2..
					i = indexE(&p0, 138);
					val = bitchk(varP, i);
				}
				else val = (*varP)>>1;												// if single I or F or etc
				Val[nextChar - val_char] = (minus) ? -val : val;
				*p2++ = nextChar++;
			}
				break;
			case 'J':{
				u8 i = 0;
				u8 val;
				p0++;
				i = indexE(&p0,138);
				val = (halt&(1 << i)) ? 0 : 1;										// if halted then Job=0
				Val[nextChar - val_char] = (minus) ? -val : val;
				*p2++ = nextChar++;
			}
				break;
				default:{
					if (*p0 < max_$ && *p0 > min_$) no$ = FALSE;
					*p2++ = *p0++;
					minus = 0;
				}
				break;
			}
		}
		if (nextChar >= max_v) return 0;
	}
	*p2 = '\0';

	//TRACE_DEBUG("STRING=%s,A=%d,B=%d,C=%d,D=%d\r\n",String,Val[0],Val[1],Val[2],Val[3]);
	/**
	* PROCESS EXPRESSION
	* String A+(B-C)*D ready
	* Val[] filled with values of A,B,C,D
	*
	*/

	while (1){
		u16 i,len = my_strlen(String);
		u8 Findex;									// final result index, pointing to Val[nextChar - val_char] or  $[next$har - $_char]
		if (len == 1){
			if (String[0] < max_$ && String[0]>min_$) Findex=next$har - 1;			// return 'a','b' etc
			else Findex = nextChar-1;							// if 'A','B' etc
			goto Lab_E;										        // if just 1 diggit, return it
		}
		p1 = 0;                            // must be =NULL instead =0; needs to include <stdio.h> for PIC processors
		p2 = String + len;
		for (i = 0; i<len; i++){
			if (String[i] == '(') p1 = &String[i];
			else if (String[i] == ')') { p2 = &String[i]; if (p1 != 0) break; } // must be !=NULL instead !=0; needs to include <stdio.h> for PIC processors
		}

		if (p1 != 0){                        // () found
			s16 result;
			len = p2 - p1;
			for (i = 0; i<len - 1; i++){
				BraStr[i] = *(p1 + i + 1);
			}
			BraStr[i] = '\0';
			BraStr[i+1] = '\0';
			*p1 = noBracket(BraStr, no$);
			while (*p2 > 0){
				*++p1 = *++p2;
			}
			*++p1 = 0;
			*(p1 + 1) = 0;
		}
		else{
			Findex = noBracket(String,no$);
Lab_E:
			if (Findex < max_$ && Findex > min_$){				// if 'a','b' etc
				u8 *q;
				out$.len = (*table[Findex - $_char].$p_len < MAX_L$) ? *table[Findex - $_char].$p_len : MAX_L$-1;
				fl_memcpy(out$.val, table[Findex - $_char].$p_val, out$.len);
				out$.val[out$.len] = '\0';
				q = out$.val;
				return indexE(&q,10);								// try to convert to int base 10
			}
			else return Val[Findex-val_char];
		}
	}
	return 0;           // just for compiler error
}

s16 $Ex(u8 * p){

	nextChar = val_char;
	wIndex = 0;                                     // index where to write next work$
	next$har = $_char;
	work$[wIndex].len = 0;
	out$.len = 0;
	out$.val[0] = 0;
	return do$Ex(p);
}

