/*
 * File:   mumps.c
 * Author: Parev
 *
 * Created on ???????, 2014, ??? 27, 14:12
 */

//#include "USBconfig.h"			//!!!
#include "globals.h"


//union {
//    u8 value;
//
//    struct {
//        u8 E : 1; // END flag
//        u8 B : 1; // BREAK flag
//        u8 S : 1; // STEP flag
//        u8 C : 1; // CYCLE flag
//        u8 L : 1; // LOAD_mPROGRAM
//        u8 R : 1; // READ goes
//		u8 b6 :1;
//		u8 b7 :1;
//    } f;
//} static mode;
//*/
//#define _CYCLE 8
//#define _STEP 4
#define STACK_DEEP 8


typedef struct {
	u16 position;
	u16 row;
	union{
		u8 task;
		struct{
			u8 taskN : 6;
			u8 E_F : 1;										// Event flag
			u8 T_F : 1;										// Time flag
		};
	};
} t_Stack;													/// PUSH first increments StackPointer, then writes to Stack using StackPointer

static t_Stack rowStack[NUM_TASK][STACK_DEEP] = { 0, 0 };    /// holds return row&point of a called subroutine
static u8 rowStackIndex[NUM_TASK] = { 0 };          			/// Index to row in taskStack for each task
static t_Stack stopPos = { 0, 0, 0 }; 						/// pointer to current row, and cycle stop position
u8 task;													/// current active task
u8 myRow[MAX_BUFFER] = {0};									/// holds a copy of current mule processing row
u8 *curRow = myRow;											/// pointer to myRow
u16 rowN = 0;				            					/// row number and stop rowN:. Holds index of m_program current line !!!
u8 ifCount = 0;                      			  			//  inc and dec in expression

const char *day[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
const char BREAK[] = "Break at line:%i, pos:%j!";


#define secTau  999                                         /// Adjust this! Number of os_timer ticks in 1/4 sec. !!!
static u16 secCount = 0;


#define _CYCLE	8											/// Flags position, according to 'mode' definition
#define _STEP	4
#define _END	1


/****************
 * HELP FUNCTIONS
****************/
u8 getIndex(){												/// return index of an object ex: V1,O2,...,F  will return 1,2...,255
	if ((*curRow > 0x2f && *curRow < 0x3a) || *curRow=='(') return indexE(&curRow, 138);
	else return 255;
}

void doTimers(void *arg){
	u8 i, step = 1;
    BOOL _1=FALSE;
																				// if Timers not stopped
    if(++secCount>secTau){
         _1=TRUE;
         //TRACE_DEBUG("%d s\r\n",secCount);
         secCount=0;
         myDate[5]++;
        if(myDate[5]==240){									/// One minute counts 240 ticks=sec/4!
            myDate[5]=0;
            updateDT();										/// call every minute
        }
    }
	if (mode.f.B || mode.f.E) step = (sizeof(RANGE) * 8);						// will process only T0 and Job0
	for (i = 0; i < (sizeof(RANGE) * 8) + NUM_TASK; i+=step) {
		if ((allTimers[i].value) > 0 && (!allTimers[i].sek || _1)) {
			//TRACE_DEBUG("Timer%d=%d\r\n",i,allTimers[i].value);
			if ((--allTimers[i].value) == 0) {
				if (i >= (sizeof(RANGE) * 8)){
					u8 j = i - (sizeof(RANGE) * 8);
					halt &= ~(1 << j);
					if (rowStack[j][rowStackIndex[j]].E_F){
						rowStack[j][rowStackIndex[j]].position--;			// poin to '?' and will check condition and execute 'TRUE' or 'FALSE'
					}
				}
				else if(mode.f.L && i==0) {
					writeFile();
					toP0((u8*)"W stopped!", 0, 0);
				}
				else  bitset(&myTimers, i);
					//TRACE_DEBUG("Timer%d!\r\n",i);
			}
		}
   }
   system_os_post(USER_TASK_PRIO_0,0,'0');
}

void ICACHE_FLASH_ATTR push(u8 task){			// push task,position and  rowN in current task Stack. Set T_F and E_F before calling!
	u8 taskN = task & 0x3f;
	rowStackIndex[taskN]++;
	if (rowStackIndex[taskN] >= STACK_DEEP) { err = 10; return; }	/// Stack overflow
	rowStack[taskN][rowStackIndex[taskN]].position = (u16) (curRow-myRow);
	rowStack[taskN][rowStackIndex[taskN]].row = rowN;
	rowStack[taskN][rowStackIndex[taskN]].task = task;
}

void ICACHE_FLASH_ATTR pop(u8 task){				// if zero=1 pops fromStack current task stack-pointer curRow & rowN, else loads zero stack-pointer, loading next task. Loads myRow
	u8 taskN = task & 0x3f;
	u8 myStackIndex = rowStackIndex[taskN];
	curRow = myRow + rowStack[taskN][myStackIndex].position;
	rowN = rowStack[taskN][myStackIndex].row;
	task = rowStack[taskN][myStackIndex].taskN;
	if ((halt & (1UL << taskN)) == 0){
		if (rowStack[taskN][myStackIndex].E_F || rowStack[taskN][myStackIndex].T_F) rowStackIndex[taskN]--;					//if not halt && wait position modify stack pointer
	}
	loadRow(rowN);
}

void ICACHE_FLASH_ATTR breakCheck(u8 task){
	if (mode.f.S) {
		mode.f.S = 0;
		mode.f.B = 1;
		stopPos.position = (u16) (curRow-myRow);
		stopPos.task = task;
		stopPos.row = rowN;
		toP0((u8*)BREAK, rowN, (u16)stopPos.position);
	}
}

u8 ICACHE_FLASH_ATTR loadTimer(u8 i)
{
	if (*curRow == '{'){
		curRow++;
		//INTCONbits.TMR0IE=0;
		allTimers[i].value = ((u16) Ex(&curRow,0)) << 2;       // *4 + correction
		if (*curRow == DEL || *curRow == ' ') curRow++;
		if (*curRow == 'm' || *curRow == 'M'){
			allTimers[i].sek = 0;
		}
		else {
			allTimers[i].sek = 1;
		}
		bitclr(&myTimers, i);
	}
	while (*curRow != '}' && *curRow!=DEL && *curRow>0)curRow++;
	if(*curRow=='}') curRow++;
	return 0;
}

BOOL ICACHE_FLASH_ATTR muleInit() {
	u8	*old_p,i;
	u8 attributes[100] = { 0 };
	/*
	 myStreams[0].pipe_count = 1;
	 myStreams[0].rxPipe.val = Pipe0.rxBuffer.val;
	 myStreams[0].rxPipe.len = &Pipe0.rxBuffer.len;
	 myStreams[0].txPipe.val = Pipe0.txBuffer.val;
	 myStreams[0].txPipe.len = &Pipe0.txBuffer.len;
	 *myStreams[0].rxPipe.val = '\0';				// P0 (console) init
	 *myStreams[0].rxPipe.len = 0;
*/
	halt = 1;										// block J0 - console
	task = 0;										// in case no m_prg found
	rowStack[0][0].task = 0x00;						// task 0
	old_p = &rowStack[0][0].task;					// when first Job found its task goes here
	rowStack[0][1].task = 0;
	rowStack[0][1].position = 0;
	rowStack[0][1].row = 0;
	rowStackIndex[0] = 1;
	ifCount = 0;
	myIns = 0;
	myOuts = 0;
	myFlags = 0;
	myTimers = 0;
	//myPipes=0;										// as we do not close Pipes don't clear
	out$.len = 0;
	for (i = 0; i<sizeof(RANGE) * 8; i++) {
		myAnalogs[i] = 0;
		myVars[i] = 0;
		allTimers[i].value = 0;
		inputPins[i] = -1;
		outputPins[i] = -1;
		analogPins[i] = -1;
		my$[i].len = 0;
		//if(myInterfaces[i].state>INTF_CLOSE) (*myInterfaces[i].closeInterface)(i);
	}
	initAnalogs();
	maxRowN = 0;

	if (fileMountAddress[INTERFACES_NUM - 2].ping>0) {my_free((char*)fileMountAddress[INTERFACES_NUM - 2].ping); fileMountAddress[INTERFACES_NUM-2].ping=0;}
	myInterfaces[INTERFACES_NUM - 2].state = INTF_CLOSE;
	fl_memcpy(attributes, (u8*) "1,\"mule.ml\"", 11); attributes[11] = 0;
	if (*allInterfacesByType[FOpen] > 0) (*allInterfacesByType[FOpen])(INTERFACES_NUM - 2, attributes);
	m_len = FATtable[myInterfaces[INTERFACES_NUM - 2].id].length;
	if (myInterfaces[INTERFACES_NUM - 2].state==INTF_OPEN && m_len > 0){
		maxRowN = readMProgram();
	}
	else (*myInterfaces[INTERFACES_NUM-2].closeInterface)(INTERFACES_NUM-2);

	if (maxRowN > 0) { 										// readProgram is Processor Specific
		///clear/set Stack
		BOOL DEFAULT_TASK = TRUE;
		//typeof(m_program[0]) mp;							// char or const char
		u8 *mp;
		t_Stack *p;

		for (i = 1; i < NUM_TASK; i++) {						// Job0 reserved for console
			u16 j;
			rowStack[i][0].task = 0;
			p = &rowStack[i][1];							// Clear first in case not used
			p->task = 0;
			p->row = 0;
			p->position = 0;
			rowStackIndex[i] = 0;
			/** Stack is filled that way that bottom of current task stack (StackIndex 0) holds next task.
			*	Stack[stackIndex 1] points to current task right after Jx sentence
			* Each task takes from its stack[0] next task and loads it according to nextTask stackIndex value!
			The last Job loads task 0, which means task_end_cycle */

			for (j = 1; j<maxRowN+1; j++){					// find a Job for task i
				mp = loadRow(j);
				if (*mp == 'J'&& *(mp + 1) == (i + 0x30) && *(mp + 2) != '='){
					if (DEFAULT_TASK){						// first active task will perform beginning set job
						task = i;							// set default task
						DEFAULT_TASK = FALSE;
						stopPos.task=task;					// just in case 'X' command
						stopPos.position = 0;
						stopPos.row = 1;
					}
					rowStack[i][0].task = *old_p;			// set task_end_cycle flag (MSB of task) in case just one task. This is the End point.
					*old_p = i;								// old task will call this one
					p->row = j;								// so bottom stack of first found job will carry address to him selves
					p->position = 0;
					p->task = i;							// not set task_end_cycle flag (MSB of task). This is task entry point
					old_p = &rowStack[i][0].task;			// remember where those task stack[0].task is
					rowStackIndex[i] = 1;					// point at entry point
					break;
				}
			}
		}
		loadRow(1);
		curRow = myRow;
		rowN = 1;
		mode.value = 0;
		mode.f.C = 1;										// to load stopPos from firs active task
		return TRUE;
	}
	else {
		mode.f.E = 1; //END_PROGRAM
		return FALSE;
	}
}

/** -----------------------------------------------------------------------------
Those commands serve the user dialog through RS/USB/CSD/TCP e.t.c.
    -----------------------------------------------------------------------------
*/
u16 ICACHE_FLASH_ATTR rock(u8 intf_num)
{
	register u8 *p = myStreams[0].rxPipe.val+*myStreams[0].rxPipe.len;

	if (mode.f.L){
		if (m_len == 0){
			u16 temp = 1;
			while (*(p-temp) != 26 && temp < *myStreams[0].rxPipe.len) { temp++; }
			if (*(p-temp) == 26){
				*myStreams[0].rxPipe.len = *(myStreams[0].rxPipe.len)- temp;								// cut before <mcZ>
				temp=*myStreams[0].rxPipe.len;									// just for debug !!!!!!!!!!!!!!!!!!!!!!!
				writeFile();
				return toP0((u8*)"Load end %j!", 0, temp);
			}
		}
		else if (m_len <= *myStreams[0].rxPipe.len){							// End load caused by m_len
			writeFile();
			return toP0((u8*)"Load end!", 0, 0);
		}
		else return 0;
	}
	else {
		*p=0;																	// make a common String
		//TRACE_DEBUG("rx=%s,len=%d\r\n", myStreams[0].rxPipe.val,*myStreams[0].rxPipe.len);
		if (*myStreams[0].rxPipe.len>2 && *(p-2) =='\r' &&*(p-1)=='\n'){
			*(p-2) = 0;																// as replace 2 chars with 1 len incl. \0
			p = myStreams[0].rxPipe.val;
			*myStreams[0].rxPipe.len = removeLeading(p);
			//TRACE_DEBUG("rx=%s,len=%d", myStreams[0].rxPipe.val,*myStreams[0].rxPipe.len);
			if (*myStreams[0].rxPipe.len > 0)
			{
				switch (*p) {
					case 'L':{
						///__L__ - List dir
						return listDir();
					}
					case 'v':{
						///__v?__ - version check
						if(*(p+1)=='?')	{
							u8 ver[10]="v__-____";
							i_to$(ver+1, versionHD, 10, 1, 1, 2);
							i_to$(ver+4, versionSW*100+subversion, 10, 1, 1, 4);
							return toP0(ver, 0, 0);
						}
						else 	return toP0((u8*)"?", 0, 0);
					}
					case 'Q':{
						///__Q__ - System Query
/*
						struct station_info *ap_conn;
						ap_conn=wifi_softap_get_station_info();
						while(ap_conn){
							TRACE_DEBUG("bssid: "MACSTR", ip: "IPSTR"\r\n",MAC2STR(ap_conn->bssid), IP2STR(&ap_conn->ip));
							ap_conn=STAILQ_NEXT(ap_conn,next);
						}
						wifi_softap_free_station_info();
						//TRACE_DEBUG("N conn=%d\r\n", espconn_tcp_get_max_con());
*/
						return toP0((u8*)"free RAM=%j", 0, system_get_free_heap_size());
					}
					case 'B':
					{ ///__B__ - BREAK
						if (mode.f.B == 0){
							if (mode.f.L){
								writeFile();
								return toP0((u8*)"Load breaked", 0, 0);
							}
							else{
								mode.f.S = 1;
								return toP0((u8*)"Console break", 0, 0);
							}
						}
						else return toP0((u8*)"Breaked", 0, 0);
					}
					case 'E':
					{ ///__E__ - END program
						//mumpsInit();
						mode.f.E = 1;
						rowStack[0][0].task=0;
						rowStackIndex[0]=1;
						return toP0((u8*)"END", 0, 0);
					}
					case 'G':
					{	///__G__ - GO run program
						if (mode.f.E) muleInit();
						mode.value = 0;
						mode.f.C = 1;
						return toP0((u8*)"GO!", 0, 0);
					}
					case 'X':
					{ /// __X__ - execute next operator and stop
						if (mode.f.E) muleInit();
						mode.value = _STEP;
						return toP0((u8*)".", 0, 0);
					}
					case 'R':
					{	/// __R"name"__ - READ file to USER
						if (*myStreams[0].rxPipe.len > 1){
							u8 attributes[100] = { 0 };							// copy file_name, size to openFile attributes
							u8 *a = attributes, in_len;
							*a++ = '1';											// sub_type=File
							*a++ = ',';
							p++;
							while (*p != '"') p++;					// skip spaces e.t.c.
							in_len = my_strlen(p);
							fl_memcpy(a, p, in_len);
							if (*allInterfacesByType[FOpen] > 0){
								(*allInterfacesByType[FOpen])(INTERFACES_NUM - 1, attributes);						// open/create file as extra Inerface[INTERFACES_NUM-1] index
								if (myInterfaces[INTERFACES_NUM - 1].state == INTF_OPEN){
									h = fileMountAddress[INTERFACES_NUM - 1].ping;
									m_len = FATtable[myInterfaces[INTERFACES_NUM - 1].id].length;
									mode.f.R = 1;
									return toP0((u8*) "mem used %j bytes from %ik", FS_SIZE >> 10, m_len);
								}
								else {
									if (fileMountAddress[INTERFACES_NUM - 1].ping != NULL) {my_free(fileMountAddress[INTERFACES_NUM - 1].ping); fileMountAddress[INTERFACES_NUM-1].ping=0;}
									return toP0((u8*)"File not found", 0, 0);
								}
							}
							else return toP0((u8*) "File system not mount", 0, 0);
						}
						else return toP0((u8*) "File not specified", 0, 0);
					}
					case 'W':
					{	/// __W"name"(optional), length,0/1 skip comments__ - WRITE new file Wfile_name[NAME_LEN],size (if no size must end with mc-Z), 0/1 leave/skip comments	\
							ex: W"my_file",1024,1
						if (*myStreams[0].rxPipe.len > 1){
							u8 attributes[100] = { 0 };							// copy file_name, size to openFile attributes
							u8 *a = attributes, in_len;
							*a++ = '1';											// sub_type=File
							*a++ = ',';
							p++;
							while (*p != '"') p++;					// skip spaces e.t.c.
							in_len = my_strlen(p);
							fl_memcpy(a, p, in_len);
							if (*allInterfacesByType[FOpen] > 0) (*allInterfacesByType[FOpen])(INTERFACES_NUM - 1, attributes);						// open/create file as extra Inerface[INTERFACES_NUM-1] index
							if(myInterfaces[INTERFACES_NUM-1].state==INTF_CLOSE) {*myStreams[0].rxPipe.len=0; return 0;}
							attributes[0] = 0;
							myInterfaces[INTERFACES_NUM - 1].openPipe(0, INTERFACES_NUM - 1, attributes);					// and attach Pipe0 to it
							myStreams[0].txPipe.val = myStreams[0].txPipe.r->val;											// roll txPipe pointers back to Pipe0
							myStreams[0].txPipe.len = &myStreams[0].txPipe.r->len;
							*myStreams[0].txPipe.len = 0;
							*myStreams[0].rxPipe.len = 0;
							load_interface = intf_num;

							//mode.f.E = 1;											// END PROGRAM?
							mode.f.L = 1;
							allTimers[0].value = 120;       						/// 48->if 12 sec no new data, quit load
							allTimers[0].sek = 1;
							bitclr(&myTimers, 0);
							return toP0((u8*) ">", 0, 0);
						}
						else return toP0((u8*) "File not specified", 0, 0);
					}
					default:
					{
						halt &= ~1;													// unblock task 0
						return 255;
					}
				}
			}
			return 0;
		}
    }
	return 0;
}
/*
 * Text Analizer
 * curRow is the row in whitch we work now, initialy set to m_program[0]
 * rowP is a help row pointer
 */
u8 ICACHE_FLASH_ATTR muleSentence(u8 task){                 						// call with curRow set!
	u8 *memRow = curRow;
    switch (*curRow){
	case 'T':{
		/**
			 // __T command :__

			 * timer set format: _T<N:>{<mathExpression>,m/S}_,T<N:>{1200,mS},T<N:>{1200 S},T<N:>{0}

			 * Timer ID(period,mS/S=1);

			 ** _ex1: 'T1{1200 S'_= start timer1{period 1200,Seconds}

			 ** _ex2: 'T1{100 mS}'_= 'restart timer1{period 100 milliseconds}'
			 */
			u8 i, j;
			BOOL period = FALSE;
			curRow++;
			i = getIndex();     							// pointer will point after
			if (*curRow == '='){                           /// T<x>=<0,1,^> manipulates timer x flag
				curRow++;
				if(i!=255){
					if (*curRow == '^')  { bitxor(&myTimers, i); curRow++; }
					else if (*curRow == '0') {
						bitclr(&myTimers, i);
						allTimers[i].value = 0;
						curRow++;
					}
					else if (*curRow == '1' && (*(curRow + 1) == DEL || *(curRow + 1) == 0)){ bitset(&myTimers, i); curRow++;}
					else {
						if (Ex(&curRow,0) != 0)bitset(&myTimers, i);
						else bitclr(&myTimers, i);
					}
				}
				else{
					myTimers = Ex(&curRow, 0)<<1;
				}
			}
			else if (*curRow == '{') loadTimer(i);
			else {
				curRow = memRow;
				Ex(&curRow,0);
			}
		}
        break;
        case '?':{
          /**
				//	__IF '?' command:__

             * if sequence : format: ?<T,F,I,O,V,A,expression> <commands if TRUE> : <commands if FALSE> ;

             * T-timer,

             * F-flage,

             * I-input

             * O-output

             * V-var

             * A-analog

			 * J-job

             *_ex1: '?T2 O1=1 : ?I1 :O1=0;'_= 'if(T2)set1 else if(!I1)clr1'_
             */
           BOOL mid_if=FALSE;
		   ifCount=1;
		   curRow++;
           if(Ex(&curRow, 0)==0){
                while(ifCount>0 && *curRow!='\0'){
                  if (*curRow=='?')   {ifCount++; mid_if= FALSE;}
                  if (*curRow==':')   {ifCount--; mid_if=TRUE;}
                  if (*curRow==';'){
                    if(!mid_if) ifCount--;
                    mid_if=FALSE;
                  }
                  curRow++;                       // find ':' and poin after
               }
           }
        }
        break;
		case 'D': {
			/**
			//__D0,D1,D2,D3,D4,D5__

		    *	DateTime has two formats :show value & set value

		    *	D0 - for Year

		    *	D1 - for Month

		    *	D2 - for Day

		    *	D3 - for hour

		    *	D4 - for min

		    *	D5 - for sec*4

		    *	D6 - for Day of Week (calculates automatically)
			*/
			u8 i,val;
		    volatile u8 *varB=&myDate[0];
		    curRow++;
		    i=indexE(&curRow,138);
			if (*curRow == '='){
				curRow++;
				val = indexE(&curRow,10);
		        *(varB+i)=val;
				setDT();
				myDate[6] = dayofWeek(myDate[0], myDate[1], myDate[2]);
		    }
			else {
				curRow = memRow;
				Ex(&curRow, 0);
			}
		}
		break;
        case 'F':{
            /**
				//	__F command:__

             * command F format: F<N:>=1,     N:- flag number or (expression)

             * _ex: 'F1=0_,' = 'clear Flag1' , F1=<expression> sets F1 according to expression=0 or not
             */
           u8 i;
            curRow++;
			i = getIndex();
            if (*curRow=='='){
                curRow++;
                if(i!=255){
					if (*curRow == '^')  { bitxor(&myFlags, i); curRow++; }
					else if (*curRow == '0') { bitclr(&myFlags, i); curRow++;}
					else if (*curRow == '1' && (*(curRow + 1) == DEL || *(curRow + 1) == 0)){ bitset(&myFlags, i); curRow++; }
					else {
						if (Ex(&curRow, 0) != 0)bitset(&myFlags, i);
						else bitclr(&myFlags, i);
					}
                }
                else myFlags = Ex(&curRow, 0)<<1;
            }
			else{
				curRow = memRow;
				Ex(&curRow, 0);
			}
        }
        break;
	/**
		//__V command:__

	*		V format: V<N:>=<expression> whitch sets the Var number N : to value <expression>

*			ex: _V2=1200, V1=F1*(V2>0)*400+(F1-1)*100_ since V2>0, the last will be 400 if F1 TRUE, 100 else

			ex: V2=I	reads all the Inputs at once in a variable
*/
        case 'V':{
             u8 i;
             curRow++;
			 i = indexE(&curRow, 138);
             if(*curRow=='='){
                 curRow++;
                 myVars[i]=Ex(&curRow, 0);
             }
			 else{
				 curRow = memRow;
				 Ex(&curRow, 0);
			 }
        }
        break;
/**
	//__O command:__

*		command O hase 2 formats:

			O{11,12,..} whitch sets the list of Output pins.

			Note that in this your O0 will be 11, O1-12, etc. Output table resets on a new comand O{...}

*			O1=<bool expression> whitch seta appropriate out to exp. value (i.e. pin12)

			or O=..expr		which sets all the output at once
*/
        case 'O':{
            curRow++;
            if (*curRow=='{'){
                u8 i,j;
                curRow++;
                if(*curRow=='?'){									// if want to see all outputs list
                	u8 myString[sizeof(ALLOUTs)/sizeof(ALL_TYPE)*2+3];
                	u8 *p=myString;
                	*p++='{';
                	for(i=0; i<sizeof(ALLOUTs)/sizeof(ALL_TYPE); i++){
                		if(ALLOUTs[i]>=0){
                			p+=i_to$(p, i, 10, TRUE, FALSE, 0);
                			*p++=',';

                		}
                	}
                	*(--p)='}';
                	*(++p)=0;
                	toP0(myString,0,0);
                	curRow++;
                }
				while(*curRow!='}' && *curRow!='\0'){
					if (*curRow == DEL) {
						curRow++;
					}
					else{
						j = indexE(&curRow, 10);
						for (i = 1; outputPins[i] >= 0; i++){
							if (outputPins[i] == j) break;
						}
						outputPins[i] = j;							// if already defined as out just revrite, else add next index
						//TRACE_DEBUG("i=%d,j=%d\r\n",i,j);
						setOuts(j); 								// set just one pin j as output
						doOuts(i);									// set initial value from outputPins[]
					}
 				}
				curRow++;
                                                                       // err11 !!!
            }
            else {
				u8 i = getIndex();
                if(*curRow=='=') {
                    curRow++;
					if (i != 0xff){
						if (*curRow == '^')  { bitxor(&myOuts, i); curRow++; }
						else if (*curRow == '0') { bitclr(&myOuts, i); curRow++; }
						else if (*curRow == '1' && (*(curRow + 1) == DEL || *(curRow + 1) == 0)){ bitset(&myOuts, i); curRow++; }
						else {
							if (Ex(&curRow, 0) != 0)bitset(&myOuts, i);
							else bitclr(&myOuts, i);
						}
					}
					else myOuts = Ex(&curRow, 0)<<1;
					doOuts(i);
                }
				else{
					curRow = memRow;
					Ex(&curRow, 0);
				}
            }
        }
        break;
		/**
		//__I command:__

		*		command I  format: I{1,12,..}  sets the list of Input pins

		Note that in this case your I0 will be 1, I1-12, etc. Input table resets on a new comand I{...}
		*/
        case 'I':{
            curRow++;
            if (*curRow=='{'){
				u8 i, j;
				curRow++;
                if(*curRow=='?'){									// if want to see all outputs list
                	u8 myString[sizeof(ALLINs)/sizeof(ALL_TYPE)*2+3];
                	u8 *p=myString;
                	*p++='{';
                	for(i=0; i<sizeof(ALLINs)/sizeof(ALL_TYPE); i++){
                		if(ALLINs[i]>=0){
                			p+=i_to$(p, i, 10, TRUE, FALSE, 0);
                			*p++=',';
                		}
                	}
                	*(--p)='}';
                	*(++p)=0;
                	toP0(myString,0,0);
                	curRow++;
                }
				while (*curRow != '}' && *curRow != '\0'){
					if (*curRow == DEL) {
						curRow++;
					}
					else{
						j = indexE(&curRow, 10);
						for (i = 1; inputPins[i] >= 0; i++){
							if (inputPins[i] == j) break;
						}
						inputPins[i] = j;							// if already defined as out just revrite, else add next index
						setIns(j); 									// SET_INS = j; set just one pin j as output !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
					}
				}
				curRow++;
            }
			else{
				curRow = memRow;
				Ex(&curRow, 0);
			}
        }
        break;
		/**
		//__A command__

		*		command A  format: A{9,12,..}  sets the list of Analog (In&Out) pins

		Note that in this case your A0 will be 9, A1-12, etc. Analog table resets on a new comand A{...}
		*/
        case 'A':{
             curRow++;
            if (*curRow=='{'){
				u8 i, j;
				curRow++;
                if(*curRow=='?'){									// if want to see all outputs list
                	u8 myString[sizeof(ALLANGs)/sizeof(ALL_TYPE)*2+3];
                	u8 *p=myString;
                	*p++='{';
                	for(i=0; i<sizeof(ALLANGs)/sizeof(ALL_TYPE); i++){
                		if(ALLANGs[i]>=0){
                			p+=i_to$(p, i, 10, TRUE, FALSE, 0);
                			*p++=',';
                		}
                	}
                	*(--p)='}';
                	*(++p)=0;
                	toP0(myString,0,0);
                	curRow++;
                }
				while (*curRow != '}' && *curRow != '\0'){
					if (*curRow != DEL) {
						j = indexE(&curRow, 10);
						for (i = 1; analogPins[i] >= 0; i++){
							if (analogPins[i] == j) break;
						}
						analogPins[i] = j;							// if already defined as out just revrite, else add next index
						initAnalogs();									// !!!
						if (!setAnalog(j)) return 13;                    // err13 !!!
					}
				}
            }
			else {
				curRow = memRow;
				Ex(&curRow, 0);
			}
        }
		break;
		case '$':
		{
			/**
			//__S command__

			*	$1=... (compose a string) OR $P1= (process a pipe rcv buffer)

			 */
			u8 i, *q, *p1_val;
			u16	*p1_len;

			curRow++;
			if (*curRow == 'P'){
				curRow++;
				i = indexE(&curRow, 138);
				p1_len = myStreams[i].rxPipe.len;
				p1_val= myStreams[i].rxPipe.val;
			}
			else{
				i = indexE(&curRow, 138);
				p1_len = &my$[i].len;
				p1_val = my$[i].val;
			}
			if (*curRow == '='){
				curRow++;
				if (*curRow == '0') {
					*p1_len = 0;								//clear $ or rx $Px(i)
					curRow++;
				}
				else{
					Ex(&curRow, 0);
					*p1_len = out$.len;
					fl_memcpy(p1_val, out$.val, out$.len);
				}
			}
			else{
				curRow = memRow;
				Ex(&curRow, 0);
			}
		}
		break;
		case '"':{
			/**
			//__" " command__

			* 	".." use to fence a plane text or digit format in a string composition

			 * ex: $1="test "+"%axV1"+"\r\n"

			 */
			curRow = memRow;
			Ex(&curRow, 0);
		}
		break;
		/**
		//__U command:__

		*		Unit Set command:

		*			U<u-num>{Type, sub-type, port, ..parameters..}
		Definition of Types/SubTypes of interfaces:

		1	Serial	1		RS232
					2		RS485
					3
					4		I2C
		---------------------
		2	USB		1		USB HUB
					2		USB dev
		---------------------
		3	BT		1		Bluetooth Master
					2		Bluetooth Slave
		---------------------
		4	GSM		1		Video Call
					2		Voice Call
					3		CSD
					4		GPRS
					5		SMS
		---------------------
		5	WiFi	1		WiFi Station
					2		WiFI AP
		-----------------------------------
		6	Stream	1 		File
					2 		RAM
					3		Encrypted RAM
					4		Audio
					5		Video
		-----------------------------------
		7	NET		1		Station
					2		AP

		---------------------
		8	CAN		1		CAN Master
					2		CAN Slave
		---------------------
		9	Device	1		Analog Output
					2		PWM
					3		3-phase PWM
					4		Pulse Coder
					5		Manchester coder/decoder
					6		DTMF coder/decoder
					7		Tone Generator

		ex: U1{1,1,2,9600,8N1,0}	open Interface 1 as RS232 at port USART2, 9600bps, 8bits NoParity 1 Stop, no HDFlow control

		*/

		case'U':
		{
			u8 i,j;
			curRow++;
			i = indexE(&curRow,138);									// interface id = i_id
			if (*curRow == '{'){
				curRow++;
				if (*curRow == '0' && *(curRow+1)=='}') {				// if Un{0} -> close Interface n
					if (*myInterfaces[i].closeInterface>0)(*myInterfaces[i].closeInterface)(i);
					curRow+=2;
				}
				else if(*curRow=='?'){
                	u8 myString[100];
                	u8 *p=myString;
                	*p++='{';
					for(i=0; i<sizeof(allInterfacesByType)/sizeof(void*); i++){
						if(allInterfacesByType[i]>0){
	              			p+=i_to$(p, i, 10, TRUE, FALSE, 0);
	              			*p++=',';
						}
					}
                	*(--p)='}';
                	*(++p)=0;
                	toP0(myString,0,0);
                	curRow+=2;
				}
				else{
					u8 attributes[100] = { 0 };							// open command: Un{1,1,0,96,8N1,0} for type=1, sub-type=1, intf_id=0, BR=9600, format=8N1, NO hardware flow control
					u8 *a = attributes;
					j = indexE(&curRow, 10);							// get type of interface
					curRow++;
					if (*curRow == '$') {
						Ex(&curRow, '}');
						fl_memcpy(a, out$.val, out$.len);
						attributes[out$.len] = 0;
					}
					else {
						while (*curRow != '}' && *curRow > 0) {
							*a++ = *curRow++;
						}
						*a = 0;
					}
					if (*curRow == '}') curRow++;
					if (*allInterfacesByType[j]>0) (*allInterfacesByType[j])(i, attributes);
				}
			}
			else{
				curRow = memRow;
				Ex(&curRow, 0);
			}
		}
		break;
/**
			//__P command:__

			*		command O hase 2 formats:

			*			P<pipeN:>{interface, interfaceSet} whitch opens a bidirectional

			pipe(pipeN:) {at interface(interfaceN:) and settings(interfaceSet)}


*/
		case 'P':{
			u8 i, j, k, m;
			u16 t;
			curRow++;
			i = indexE(&curRow, 138);										// PipeN:
			if (*curRow == '{'){											// Open/Close a pipe
				curRow++;
				j = indexE(&curRow, 10);								// Interface Number
				while(*curRow ==' ' || *curRow==DEL) curRow++;
				if (*curRow == '0' && *(curRow + 1) == '}') {					// if Pn{0} -> close Pipe n
					if (*myInterfaces[j].closePipe > 0) {
						(*myInterfaces[j].closePipe)(i, j);
					}
					curRow += 2;
				}
				else{
					u8 attributes[100] = { 0 };
					u8 *a = attributes;
					//t = indexE(&curRow, 10);								// timeOut
					if (*curRow == '$') {
						Ex(&curRow, '}');
						fl_memcpy(a, out$.val, out$.len);
						attributes[out$.len] = 0;
					}
					else {
						while (*curRow != '}' && *curRow > 0) {
							*a++ = *curRow++;
						}
						*a = 0;
					}
					if (*curRow == '}') curRow++;
					if (*(myInterfaces[j].openPipe)>0) (*myInterfaces[j].openPipe)(i, j, attributes);
				}
			}
			else if (*curRow == '=' && bitchk(&myPipes, i)){									// Pipe Send
				curRow++;
				if (*curRow == '0') {
					*myStreams[i].txPipe.len = 0;								//clearPx(i);		// clear pipe
					curRow++;
				}
				else{
					Ex(&curRow, 0);
					*myStreams[i].txPipe.len = out$.len;
					fl_memcpy(myStreams[i].txPipe.val, out$.val, out$.len);
				}
			}
			else if (*curRow == '+' && bitchk(&myPipes, i)){
				s32 gap;
				s16 mylen = 0;
				curRow++;
				gap = Ex(&curRow, '=');
				if (*curRow == '=' && gap>0) {
					gap--;
					curRow++;
					Ex(&curRow, 0);
					mylen=gap+out$.len-*myStreams[i].txPipe.len;
					if(mylen>0){
						(*myStreams[i].txPipe.len)+=mylen;							// len increased as we append
					}
					fl_memcpy(myStreams[i].txPipe.val + gap, out$.val, out$.len);
				}
			}
			else{
				curRow = memRow;
				Ex(&curRow, 0);
			}
		}
        break;
        default: {
			curRow = memRow;
			Ex(&curRow, 0);
		}
    }
    return 0;
}

/** -----------------------------------------------------------------------------
MAIN Mule OPERATORS row navigation handle
-----------------------------------------------------------------------------
*/
u8 ICACHE_FLASH_ATTR mule(){                             		// main cycle
	u8 H;
	err = 0;

	// Load task 0
	task = 0;
	if(mode.f.L==0) pop(0);

	while (err == 0){												// process curRow
		//TRACE_DEBUG("%d",halt);

		H = 1 << task;												// compose mask;
		if ((mode.f.B || mode.f.E) && task > 0) { task = 0; return 0; } 			// if BREAK and not zero_task return

		if (halt & H){
			if (rowStack[task][rowStackIndex[task]].E_F){
				if (Ex(&curRow, 0)) {
					halt &= ~H;										// resume task
					allTimers[sizeof(RANGE) * 8 + task].value = 0;
					rowStackIndex[task]--;
					goto Lab_2;
				}
			}
			if (rowStack[task][0].taskN == 0) { task = 0; return 0; }			// if get to task 0 all the tasks roll over, so return. Task 0 will load next call
			if ((mode.f.S || mode.f.C) && stopPos.task>0) {
				mode.f.C = 0;
				task = stopPos.task;
				rowN = stopPos.row;
				loadRow(rowN);
				curRow = myRow + stopPos.position;
				stopPos.task = 0;
			}
			else{
				task = rowStack[task][0].taskN;										// if sill blocked load next task if any
				pop(task);
			}
			continue;
		}

	Lab_2:
		switch (*curRow){
		case 'G':{
			/**
			// __G command__

			format: _G<n>_ =GOTO Line<n>
			*/
			u16 newRow = rowN;
			curRow++;
			if (*curRow == '+') { curRow++; newRow += Ex(&curRow, 0); }
			else if (*curRow == '-') { curRow++; newRow -= Ex(&curRow, 0); }
			else newRow= Ex(&curRow, 0);
			if(newRow>0){
				rowN=newRow;
				loadRow(rowN);									// new myRow loaded and rowN set
				curRow = myRow;
				breakCheck(task);
			}
		}
		break;
		case 'Q':
		case '#':												// comment should not appear
		case '\0':{
			/**
			// __Q command__

			format: _Q_ =quit current row
			*/
			if (task == 0 && rowN==0) {
				*myStreams[0].rxPipe.len=0;
				//myStreams[0].rxPipe.val[0] = 0;
				halt |= 1;										// block task 0
				rowStackIndex[0] = 1;							// kill all subroutines entryed
				return 0;
			}
			else{
				rowN++;
				loadRow(rowN);
				curRow = myRow;
				ifCount = 0;
				breakCheck(task);
			}
		}
		break;
		case ':':{
			ifCount = 1;
			while (*curRow != '\0' && ifCount>0) { 				// find end of if or end of row. If end of row don't move from it
				if (*curRow == '?') ifCount++;
				if (*curRow++ == ';') ifCount--; 			// will point on next after
				curRow++;
			}
		}
		break;
		case 'C': {
			/**
			// __C command__

			format: _C<n>_ =CALL Line<n> call a subroutine (ends with 'E');

			after returning vill point to next comand
			*/
			u16 newRow = rowN;
			curRow++;
			if (*curRow == '+') { curRow++; newRow += Ex(&curRow, 0); }
			else if (*curRow == '-') { curRow++; newRow -= Ex(&curRow, 0); }
			else newRow = Ex(&curRow, 0);
			if(newRow>0){
				push(task);
				rowN = newRow;
				loadRow(rowN);
				curRow = myRow;
				breakCheck(task);
			}
		}
		break;
		case 'J':{
			/**
			// __J<n>__
			*
			* has 2 meaning:
			* - marks begin of a job block
			*
			*      J0- begining of main Job program
			*
			J<n>, begining of  thread/job <n>
			*
			* - rule a job, different from current
			*
			J2=1 - start job 2
			*
			J3=0 - halt job 3
			*
			nomber of jobs defined as N_tasks in 'globals'
			*/
			u8 i;
			curRow++;
			i = indexE(&curRow, 138);
			if (*curRow == '=') {
				curRow++;
				if (*curRow == '0'){
					allTimers[sizeof(RANGE) * 8 + i].value = 0;
					halt |= (1 << i);
					rowStackIndex[i] = 1;							// kill all subroutines entryed
				}
				else halt &= ~(1 << i);
			}
			while (*curRow != DEL && *curRow != '\0' && *curRow != ' ') curRow++;
		}
		break;
		case 'E':{
			/**
			// __E__

			END of a Job or return from a subroutine
			*/
			// if E of a subroutine, load current task from Stack
			if (rowStackIndex[task] > 1) {
				pop(task);
				rowStackIndex[task]--;											// position 1 is the bottom of Stack as pos 0 holds next active task number
			}
			else{
				if (rowStack[task][0].taskN == 0) { task = 0; return 0; }		// if get to task 0 all the tasks roll over, so return. Task 0 will load next call
				task = rowStack[task][0].taskN;									// if sill blocked load next task if any
				pop(task);
			}
		}
		break;
		case 'Z':{
			/**
			// __Z__

			reboot m-program
			*/
			my_reboot();														// see ProcessorSpecific.h
			//muleInit();
			return 0;
		}
		case 'B':{
			/**
			// __B__

			Format:

			B, =break; stop here;

			B(bool condition) and signal user
			*/
			curRow++;
			if (*curRow == DEL || *curRow == ' ' || *curRow == '\0' || (*curRow == '(' && Ex(&curRow, 0) != 0)) {
				mode.f.S = 1;
				breakCheck(task);
			}
		}
		break;
		case 9:																// tab
		case ';':
		case ' ':
		case DEL:{
			/**
			// __Delimiters ' ' or ','__

			<spc> or ',' are standard delimiters between operators
			*/
			curRow++;
			breakCheck(task);
		}
		break;
		case 'H':{
			/**
			// __H command :__

			* H - HALT forever (needs E & G to run again)

			* HT- HALT&WAIT a time period. Blocks in current Row position __ex1: WT(2,1)=WAIT 2sec.; W(100,0)=WAIT 100mS.

			* H?- HALT&WAIT an event. Blocks until (expression)=TRUE      __ex2: W?(I1*I2)

			* HT(3,1)?I1+I2 - HALT&WAIT 3 sek for I1 or I2 (NO DELIMITER inside text!)

			* H?$P1/"\r\n"	 - HALT until Pipe1 receives something with "\r\n" inside
			*/
			u8 *temp;
			curRow++;
			halt |= H;
			u8 task_mask=0;
			if (*curRow == 'T'){ curRow++; loadTimer(task + sizeof(RANGE) * 8); task_mask |= 0x80; }
			if (*curRow == '?'){
				temp = ++curRow;
/*
				if (*curRow == 'P') {
					u8 i;
					curRow++;
					i = indexE(&curRow, 138);
					allTimers[sizeof(RANGE) * 8 + task].value = myStreams[i].tau;
					allTimers[sizeof(RANGE) * 8 + task].sek = 0;
				}
*/
				curRow = temp;
				if (Ex(&curRow, 0) != 0) { halt &= ~H; allTimers[sizeof(RANGE) * 8 + task].value = 0; }
				else { task_mask |= 0x40;	curRow = temp; }										// set E_F to check a condition
			}
			if (halt & H){																		// if sill blocked load next task if any
				push(task | task_mask);
				if (rowStack[task][0].taskN == 0) {	task = 0; return 0;	}						// if get to task 0 all the tasks roll over, so return. Task 0 will load next call
				task = rowStack[task][0].taskN;
				pop(task);
				continue;
			}
		}
		break;
		default:{
			u8 print = 0;
			if (*curRow == '!'){
				curRow++;
				switch (*curRow){
					case '$':
					case 34:{
						print = 3;
					}
					break;
					case '_':{
						print = 2;
						//curRow++;
					}
					break;
					default: {
						print = 1;
					}
					break;
				}
			}
			err = muleSentence(task);
			if (err==0 && print){
				switch (print){
					case 3:{
						*myStreams[0].txPipe.len = out$.len;
						fl_memcpy(myStreams[0].txPipe.val, out$.val, out$.len);
						myStreams[0].txPipe.val[*myStreams[0].txPipe.len] = 0;
						//toP0(myStreams[0].txPipe.val,0,0);
					}
					break;
					case 2:{
						toP0((u8*) "%j", 0, result);
					}
					break;
					case 1: {
						toP0((u8*) "%j",0,result);
					}
					break;
				}
			}
		}
		break;
		}
	}
	toP0((u8*) "errN:%i, line:%j!", err, rowN);
	*myStreams[0].rxPipe.len = 0;
	halt |= 1;										// block task 0
	rowStackIndex[0] = 1;							// kill all subroutines started from task 0
	mode.f.E = 1;

	return err;
}

