//---------------------------------------------------------------------------------------------------------------
//		USEFUL SUBROUTINES
//---------------------------------------------------------------------------------------------------------------
#include "globals.h"
//-----------------------------
// bit operations !ByAddress
//-----------------------------
void ICACHE_FLASH_ATTR  bitset(volatile RANGE *f,u8 b)
{
	RANGE temp=1;
	temp<<=b;
    *f|=temp;			// *f = *f OR temp
}
void ICACHE_FLASH_ATTR  bitxor(volatile RANGE *f,u8 b)
{
	RANGE temp=1;
	temp<<=b;
        *f^=temp;		// *f = *f XOR temp
}
BOOL ICACHE_FLASH_ATTR  bitchk(volatile RANGE *f,u8 b)
{
	RANGE temp=1;
	temp<<=b;
	if (temp & *f) return(TRUE);
	else return(FALSE);
}
void ICACHE_FLASH_ATTR  bitclr(volatile RANGE *f,u8 b)
{
	RANGE temp=1;
	temp<<=b;
    *f&=(~temp);		// *f = *f AND COMF(temp);
}
//--------------------------------------------------------------------------------------------------------------------------------------------
u16 toP0(u8* q, u8 i, s16 j){
	u16 my_len=my_strlen(q)+10;						// give 10 bytes for i and j
	if((my_len+*myStreams[0].txPipe.len)<MAX_BUFFER){
		(*myStreams[0].txPipe.len) += my_sprintf(myStreams[0].txPipe.val+*myStreams[0].txPipe.len, q, i, j);
	}
		//TRACE_DEBUG("toP0 %s len %d\r\n", myStreams[0].txPipe.val, *myStreams[0].txPipe.len);
	return *myStreams[0].txPipe.len;
}
//--------------------------------------------------------------------------------------------------------------------------------------------
u8 ICACHE_FLASH_ATTR dayofWeek(u8 yy, u8 mm, u8 dd){											// calculates day of week from 2000 to 2099 year using (dd+[mm]+yy+int(yy/4)+c) mod 7
	u8 dw=0;
	const char m_table[13]={0,0,3,3,6,1,4,6,2,5,0,3,5};			// common month table
	const char M_table[13]={0,6,2,3,6,1,4,6,2,5,0,3,5};			// Leap years month table (devided by 4 ex.)
	dw=((yy % 4)==0) ? M_table[mm] : m_table[mm];
	dw+=(dd+yy+(u8) (yy/4)+6);																// c=6 is century diggit
	dw%=7;
	return dw;																							// 0-Sun, 1-Mon, 2-Tue, 3-Wed, 4-Thu, 5-Fri, 6-Sat
}
//--------------------------------------------------------------------------------------------------------------------------------------------
u16 ICACHE_FLASH_ATTR  my_strlen(u8 *p){
    u16 strlen=0;
    while(*p) {p++;strlen++;}
    return strlen;
}

//--------------------------------------------------------------------------------------------------------------------------------------------
// process mesage from pointer to inString and move those pointer to the end of possible mesage. If myChr<128, clear all variables in PRG Ex(), else don't
//--------------------------------------------------------------------------------------------------------------------------------------------
s16 ICACHE_FLASH_ATTR Ex(u8 **pn, u8 myChr){
	u8 *p = inString;
	bool notQuot = TRUE, FROM=TRUE;
	if (myChr > 127) {FROM = FALSE; myChr -= 128;}
	while (**pn != '\0' && (!notQuot || (notQuot && **pn != DEL && **pn != ' ' && **pn != ':' && **pn != ';' && **pn != myChr)))
	{
		if (**pn == 92){											// if '\x'
			*p++ = **pn;
			(*pn)++;
			*p++ = **pn;
			(*pn)++;
		}
		if (**pn == 34) notQuot = (notQuot) ? FALSE : TRUE; 		// if "......" don't check ^ in'while'
		*p++ = **pn;												// transfer expression to start do it
		(*pn)++;
	}
	//if (!notQuot){
	//	if (*(p - 1) == 34) *(p - 1) = 0;
	//	else *p++ = 34;										// if ".... left open, so close them
	//}
	*p = '\0';
	//TRACE_DEBUG("inString=%s\r\n",inString);
	if (FROM) result = $Ex(inString);				// proces a whole msg
	else result = do$Ex(inString);					// process recurrent in-row msg
	return (result);
}

//--------------------------------------------------------------------------------------------------------------------------------------------
// produces a digit from char pointer to a String and move those pointer to the end of possible digit in String, according to base passed (10 or16)
//--------------------------------------------------------------------------------------------------------------------------------------------
s16  ICACHE_FLASH_ATTR indexE(u8 **pn, u8 i_base){
    u16 gid=0;
	BOOL b = TRUE, minus=FALSE;
	union{
		u8 input_base;
		struct{
			u8 base:7;									// base to transfer digit =10,16..
			u8 i_check:1;								// if i_check==1 perform check if index inside RANGE
		};
	}ib;

	ib.input_base=i_base;
	if (**pn == '('){
		u8 Ex$[MAX_L$]="(";
		u8 *q = Ex$+1;
		u8 bra_count = 1;
		(*pn)++;
		while (**pn != DEL && bra_count > 0 && **pn != 0) {
			*q++ = **pn;								// transfer expression to start do it
			if (**pn == '(') bra_count++;
			else if (**pn == ')') bra_count--;
			(*pn)++;									// will points after last ')'
		}
		*q = '\0';
		gid= (do$Ex(Ex$));
	}
	else{
		while (**pn==' ' || **pn==DEL) (*pn)++;			// skip leading ' ' and ','
		if (**pn == '-'){
			if (ib.i_check == 0) minus = TRUE;
			(*pn)++;
		}
		while (b && **pn != '\0'){
			b = FALSE;
			if (**pn > 0x2f && **pn < 0x3a) { gid = gid*ib.base + **pn - '0'; b = TRUE; }
			else if (ib.base == 16){
				if (**pn>0x40 && **pn < 0x47) { gid = (gid << 4) + **pn - 55; b = TRUE; }		//'A'-10
				else if (**pn>0x60 && **pn < 0x67) { gid = (gid << 4) + **pn - 87; b = TRUE; }	//'a'-10
			}
			if (b) (*pn)++;
		}
	}
	if(ib.i_check && gid>=sizeof(RANGE)*8) gid=0;
	if(minus) return -gid;
	else return gid;
}

//--------------------------------------------------------------------------------------------------------------------------------------------
// adds a diggit with 'dlen' signs as Val or ASCII to a u8 *pn=String and returns dlen to move those pointer to the end of diggit in String, according to 'base' passed (10 or16)
//--------------------------------------------------------------------------------------------------------------------------------------------
u8 ICACHE_FLASH_ATTR  i_to$(u8* pn, s16 dig2, u8 base, bool CHR, bool UP_C, u8 dlen){
	u8 i;
	if (dig2 < 0 && base == 10){
		//if (p1 > BraStr && (*(p1 - 1) == '+')){ p1--; }   //if '..+' and not at beginning of the work$
		*pn++ = '-';
		dig2 = -dig2;
	}
	if (dlen == 0){                               // type 0xV1,0dV2
		RANGE w = dig2;
		do {
			w /= base;
			dlen++;
		} while (w != 0);
		if (!CHR) dlen = (dlen >> 1) + (dlen % 2);
	}
	pn += dlen;                                  // points on last
	for (i = 0; i < dlen; i++){
		char c = 0;
		if (CHR){
			c = dig2 % base + '0';
			dig2 /= base;
			if (c>0x39) c+= (UP_C) ? 7 : 0x27;                          // transfer to 'A','B',..'F' or 'a','b',...
		}
		else{
			c = dig2 % base;
			dig2 /= base;
			c += (dig2 % base) << 4;
			dig2 /= base;
		}
		*(pn - i - 1) = c;
	}
	return dlen;
}
/**------------------------------------------------------------------------------
	Copy p2 to p1, len
*/
void ICACHE_FLASH_ATTR  fl_memcpy(u8 *pd, u8 *ps, u16 len)
{
    //TRACE(0x30+len);
    while (len){*pd++=*ps++; len--;}
}
/*
u8 fl_dtoa(volatile char *pa,u16 dig,u8 base){
    //writes in '*pa' backward 'dig' according 'base'

}
*/
//------------------------------------------------------------------------------
u8 ICACHE_FLASH_ATTR  my_sprintf(u8 *p, u8 *q, u8 i, s16 j){

    u8 len=0;
    while (*q && len<(MAX_L$-2)){
        if(*q=='%'){
            u16 v,w;
            u8 d_len=0;
            char c;
            q++;
            if(*q=='i') w=i;
            else{
                if(j<0) {w=-j;*p++='-'; len++;}
                else w=j;
            }
            v=w;
            do {
		w /= 10;
		p++;
                d_len++;
            } while(w != 0);
            do {
                   c = v % 10;
                    v /= 10;
                    *(--p)=c+'0';
            } while(v != 0);
            p+=d_len;
            len+=d_len;
            q++;
        }
        else {
			if (*p == 92) p++;					//if '\'
			*p++=*q++;
			len++;
        }
        //if(*q==26)break;
    }
    if(*q==0){
        *p++='\r';
        *p++='\n';
		*p = '\0';
        len+=2;
    }
    return len;
}


u16 ICACHE_FLASH_ATTR  removeLeading(u8 *p)						// will return new length
{
	u8 *e=p;
	u16 len=my_strlen(p);
	while ((*e<26) && (*e>'\0')) e++;							// LEAVE <mc>Z and <esc>!

	if (e!=p)
	{
		len=0;
		while (*e!='\0')
		{
			*p=*e;
			p++;
			e++;
			len++;
		}
		*p='\0';
	}
	return len;
}

//--------------------------------------------------------------------------------------------------------------------------------------------
void ICACHE_FLASH_ATTR  cutString(u8 *my, u8 *out, u16 outlen)					// cuts string(out) from string(my) with len = mylen produces 2 strings out with (outlen) and my=my-out from the beggining of my
{
	u16 mylen=my_strlen(my);
	u16 i, end;
	if (outlen<=mylen)
	{
		end= ((mylen-outlen)>outlen) ? (mylen-outlen) : outlen;
			//TRACE_DEBUG("end=%d\r\n",end);
		for (i=0;i<end;i++)
		{
				//TRACE_DEBUG("i=%d\r\n", i);
			*(out+i)= (i<outlen) ?  *(my+i) : 0x00;
			*(my+i)= (i<(mylen-outlen)) ? *(my+i+outlen) : 0x00;
				//TRACE_DEBUG("out=%d, my=%d\r\n", *(out+i), *(my+i));
		}
		*(my+i)='\0';
		*(out+i)='\0';
	}
}
//----------------------------------------------------------------------------------------------------------------------------

void ICACHE_FLASH_ATTR  add_char(u8 *MyString, char MyChar)						// add char(MyChar) to a string(MyString)
{
	int length=my_strlen(MyString);
	*(MyString+length)=MyChar;
	*(MyString+length+1)='\0';
}

//----------------------------------------------------------------------------------------------------------------------------
u8* ICACHE_FLASH_ATTR  find_char(unsigned char *MyString, char MyChar)					// return pointer to found char or NULL
{
	while(*MyString > 0){
		if(*MyString==MyChar) return MyString;
		MyString++;
	}
	return NULL;
}
//----------------------------------------------------------------------------------------------------------------------------

u8* ICACHE_FLASH_ATTR my_strstr(u8 *p, u8 *q){			// return a pointer to found string
	u8 j = 0;
	u8 i = 0;
	u16 len1=my_strlen(p);
	u16 len2=my_strlen(q);
	s16 dif = 1 + len1 - len2;
	if (dif>0 && dif<=len1){
		for (i = 0; i < dif; i++){
			for (j = 0; j < len2; j++){
				if (*(p +i + j) != *(q+j)) break;
			}
			if (j == len2) return(p+i);
		}
	}
	return NULL;
}

//--------------------------------------------------------------------------------------------------------------------------------------------
/*
bool ICACHE_FLASH_ATTR help(u8* pp, const char * hp){									// program that serves help '?'-in a init Pipe/Unit string
	while(*pp>0){																		// param pointer
		if(*pp=='?'){
			while(*hp>0){
				*pp++=*hp++;
			}
			return TRUE;
		}
		if(*pp==','){																	// move hp to the next ','
			while(*hp>0 && *hp!=','){
				hp++;
			}
		}
	}
	return FALSE;
}
*/
//--------------------------------------------------------------------------------------------------------------------------------------------
void ICACHE_FLASH_ATTR my_memset(u8* start, u8 val, u16 len){
	while (len){
		*start++ = val;
		len--;
	}
}

/** ----------------------------------------------------------------
 * 	close Interface[INTRFACES_NUM-1]. If mode.f.M set, remove comments
 * ---------------------------------------------------------------*/
void ICACHE_FLASH_ATTR writeFile(){
	ETS_UART_INTR_DISABLE();
	mode.f.L=0;
	allTimers[0].value = 0;       					/// stop Timer0
	if (mode.f.M){
		u16 *lenp = myStreams[0].rxPipe.len;
		bool NEW_ROW = TRUE, COMMENT = FALSE;
		u8	*s = myStreams[0].rxPipe.val;
		u8	*d=s;
		u8	*end = myStreams[0].rxPipe.val + *myStreams[0].rxPipe.len;
		mode.f.M = 0;
		*lenp = 0;
		while (s < end){
			if (NEW_ROW && (*s == ' ' || *s == 9)) continue;
			NEW_ROW = FALSE;
			if (*s == '\r') COMMENT = FALSE;											// end of row=end of comment
			if (*s == '\n') NEW_ROW = TRUE;
			if (*s == '#'){
				COMMENT = TRUE;												// beginning of a comment
				while (*lenp > 0 && (*(d - 1 + *lenp) == ' ' || *(d - 1 + *lenp) == 9)) {
					(*lenp)--;
				}
			}
			if (COMMENT) { s++; continue; }											// if comment skip it
			*(d + *lenp) = *s++;
			(*lenp)++;
		}
	}
	(*myInterfaces[INTERFACES_NUM - 1].closeInterface)(INTERFACES_NUM - 1); // in EEPROM
	myStreams[0].pipe_count = 1;
	/*
	myStreams[0].rxPipe.val = Pipe0.rxBuffer.val;
	myStreams[0].rxPipe.len = &Pipe0.rxBuffer.len;
	myStreams[0].txPipe.val = Pipe0.txBuffer.val;
	myStreams[0].txPipe.len = &Pipe0.txBuffer.len;
	*/
	myStreams[0].rxPipe.val = myStreams[0].rxPipe.r->val;
	myStreams[0].rxPipe.len = &(myStreams[0].rxPipe.r->len);
	myStreams[0].txPipe.val = myStreams[0].txPipe.r->val;
	myStreams[0].txPipe.len = &(myStreams[0].txPipe.r->len);
	*myStreams[0].rxPipe.val = '\0';				// P0 (console) init
	*myStreams[0].rxPipe.len = 0;
	//ebdat3_09FlashFileWrite(m_len, (u8*) m_Buffer, (u8*)"m_program", FL_FILE_FROM_BEGINNING);
}
//--------------------------------------------------------------------------------------------------------------------------------------------
bool  ICACHE_FLASH_ATTR createPipe(u8 pipe){
	if (myStreams[pipe].pipe_count == 0){
		myStreams[pipe].txPipe.r = (t_Buffer*) os_malloc(sizeof(t_Buffer));
		myStreams[pipe].rxPipe.r = (t_Buffer*) os_malloc(sizeof(t_Buffer));
	}
	if (myStreams[pipe].txPipe.r>0){
		myStreams[pipe].txPipe.val = myStreams[pipe].txPipe.r->val;
		myStreams[pipe].txPipe.len = &(myStreams[pipe].txPipe.r->len);
	}
	else return FALSE;
	if (myStreams[pipe].rxPipe.r>0){
		myStreams[pipe].rxPipe.val = myStreams[pipe].rxPipe.r->val;
		myStreams[pipe].rxPipe.len = &(myStreams[pipe].rxPipe.r->len);
	}
	else return FALSE;
	*myStreams[pipe].txPipe.len=0;
	*myStreams[pipe].rxPipe.len=0;
	bitset(&myPipes, pipe);
	myStreams[pipe].pipe_count++;
	return TRUE;
}

void freePipeCheck(u8 pipe){
	myStreams[pipe].pipe_count--;
	if (myStreams[pipe].pipe_count <= 0) {
		myStreams[pipe].pipe_count = 0;
		if (myStreams[pipe].rxPipe.r) my_free((char*)myStreams[pipe].rxPipe.r);
		if (myStreams[pipe].txPipe.r) my_free((char*)myStreams[pipe].txPipe.r);
		myStreams[pipe].rxPipe.r=0;
		myStreams[pipe].txPipe.r=0;
		myStreams[pipe].rxPipe.len = 0;
		myStreams[pipe].rxPipe.val = 0;
		myStreams[pipe].txPipe.len = 0;
		myStreams[pipe].txPipe.val = 0;
		bitclr(&myPipes,pipe);
		TRACE_DEBUG("No more Pipe%d\r\n", pipe);
	}
}
