#ifndef UART_APP_H
#define UART_APP_H

//#include "ets_sys.h"
//#include "osapi.h"
#include "uart_register.h"
#include "eagle_soc.h"
#include "c_types.h"
#include "globals.h"

#define RX_BUFF_SIZE    MAX_BUFFER
#define TX_BUFF_SIZE    MAX_BUFFER
#define UART0   0
#define UART1   1
volatile u8 *mp;

typedef enum {
    FIVE_BITS = 0x0,
    SIX_BITS = 0x1,
    SEVEN_BITS = 0x2,
    EIGHT_BITS = 0x3
} UartBitsNum4Char;

typedef enum {
    ONE_STOP_BIT             = 0,
    ONE_HALF_STOP_BIT        = BIT2,
    TWO_STOP_BIT             = BIT2
} UartStopBitsNum;

typedef enum {
    NONE_BITS = 0,
    ODD_BITS   = 0,
    EVEN_BITS = BIT4
} UartParityMode;

typedef enum {
    STICK_PARITY_DIS   = 0,
    STICK_PARITY_EN    = BIT3 | BIT5
} UartExistParity;

typedef enum {
    BIT_RATE_9600     = 9600,
    BIT_RATE_19200   = 19200,
    BIT_RATE_38400   = 38400,
    BIT_RATE_57600   = 57600,
    BIT_RATE_74880   = 74880,
    BIT_RATE_115200 = 115200,
    BIT_RATE_230400 = 230400,
    BIT_RATE_460800 = 460800,
    BIT_RATE_921600 = 921600
} UartBautRate;

typedef enum {
    NONE_CTRL,
    HARDWARE_CTRL,
    XON_XOFF_CTRL
} UartFlowCtrl;

typedef enum {
    EMPTY,
    UNDER_WRITE,
    WRITE_OVER
} RcvMsgBuffState;

typedef struct {
    uint32     RcvBuffSize;
    uint8     *pRcvMsgBuff;
    uint8     *pWritePos;
    uint8     *pReadPos;
    uint8      TrigLvl; //JLU: may need to pad
    RcvMsgBuffState  BuffState;
    u16 		len;	// current length of message
    u8 			pipe;
} RcvMsgBuff;

typedef struct {
    uint32   TrxBuffSize;
    uint8   *pTrxBuff;
} TrxMsgBuff;

typedef enum {
    BAUD_RATE_DET,
    WAIT_SYNC_FRM,
    SRCH_MSG_HEAD,
    RCV_MSG_BODY,
    RCV_ESC_CHAR,
} RcvMsgState;

typedef struct {
    UartBautRate 	    baut_rate;
    UartBitsNum4Char  	data_bits;
    UartExistParity     exist_parity;
    UartParityMode 	    parity;    		// chip size in byte
    UartStopBitsNum   	stop_bits;
    UartFlowCtrl        flow_ctrl;
    RcvMsgBuff          rcv_buff;
    TrxMsgBuff          trx_buff;
    RcvMsgState        	rcv_state;
    int                 received;
    int                 buff_uart_no;  	//indicate which uart use tx/rx buffer
} UartDevice;

// From uart.c
void RS232Open(u8,u8*);
//void uart0_sendStr(const char *str);
//u8 uart_send(u8 uart, t_String msg);
//u8 uart_close(u8);
#endif

